# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1608-1 (mysql-dfsg-5.0)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61283);
 script_cve_id("CVE-2008-2079");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1608-1 (mysql-dfsg-5.0)";
 script_name(name);

 desc = "The remote host is missing an update to mysql-dfsg-5.0
announced via advisory DSA 1608-1.

Sergei Golubchik discovered that MySQL, a widely-deployed database
server, did not properly validate optional data or index directory
paths given in a CREATE TABLE statement, nor would it (under proper
conditions) prevent two databases from using the same paths for data
or index files.  This permits an authenticated user with authorization
to create tables in one database to read, write or delete data from
tables subsequently created in other databases, regardless of other
GRANT authorizations.  The Common Vulnerabilities and Exposures
project identifies this weakness as CVE-2008-2079.

For the stable distribution (etch), this problem has been fixed in
version 5.0.32-7etch6.  Note that the fix applied will have the
consequence of disallowing the selection of data or index paths
under the database root, which on a Debian system is /var/lib/mysql;
database administrators needing to control the placement of these
files under that location must do so through other means.

We recommend that you upgrade your mysql-dfsg-5.0 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201608-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1608-1 (mysql-dfsg-5.0)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mysql-client", ver:"5.0.32-7etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-common", ver:"5.0.32-7etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server", ver:"5.0.32-7etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient15off", ver:"5.0.32-7etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient15-dev", ver:"5.0.32-7etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server-5.0", ver:"5.0.32-7etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server-4.1", ver:"5.0.32-7etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client-5.0", ver:"5.0.32-7etch6", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
