# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1193-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58696);
 script_cve_id("CVE-2006-3467", "CVE-2006-3739", "CVE-2006-3740", "CVE-2006-4447");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1193-1 (xfree86)";
 script_name(name);

 desc = "The remote host is missing an update to xfree86
announced via advisory DSA 1193-1.

Several vulnerabilities have been discovered in the X Window System,
which may lead to the execution of arbitrary code or denial of service.
The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2006-3467

Chris Evan discovered an integer overflow in the code to handle
PCF fonts, which might lead to denial of service if a malformed
font is opened.

CVE-2006-3739

It was discovered that an integer overflow in the code to handle
Adobe Font Metrics might lead to the execution of arbitrary code.

CVE-2006-3740

It was discovered that an integer overflow in the code to handle
CMap and CIDFont font data might lead to the execution of arbitrary
code.

CVE-2006-4447

The XFree86 initialization code performs insufficient checking of
the return value of setuid() when dropping privileges, which might
lead to local privilege escalation.

For the stable distribution (sarge) these problems have been fixed in
version 4.3.0.dfsg.1-14sarge2. This release lacks builds for the
Motorola 680x0 architecture, which failed due to diskspace constraints
on the build host. They will be released once this problem has been
resolved.

For the unstable distribution (sid) these problems have been fixed
in version 1:1.2.2-1 of libxfont and version 1:1.0.2-9 of xorg-server.

We recommend that you upgrade your XFree86 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201193-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1193-1 (xfree86)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"pm-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"x-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"x-window-system", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-100dpi-transcoded", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-100dpi", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-75dpi-transcoded", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-75dpi", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-base-transcoded", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-base", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-cyrillic", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-scalable", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfree86-common", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibmesa-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibmesa3-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibs-data", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibs-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibs-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibs-pic", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibs", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xspecs", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lbxproxy", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdps-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdps1", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdps1-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libice-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libice6", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libice6-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsm-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsm6", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsm6-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libx11-6", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libx11-6-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libx11-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxaw6", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxaw6-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxaw6-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxaw7", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxaw7-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxaw7-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxext-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxext6", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxext6-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxft1", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxft1-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxi-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxi6", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxi6-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxmu-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxmu6", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxmu6-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxmuu-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxmuu1", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxmuu1-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxp-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxp6", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxp6-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxpm-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxpm4", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxpm4-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxrandr-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxrandr2", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxrandr2-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxt-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxt6", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxt6-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxtrap-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxtrap6", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxtrap6-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxtst-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxtst6", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxtst6-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxv-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxv1", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxv1-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proxymngr", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"twm", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"x-window-system-core", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"x-window-system-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xbase-clients", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xdm", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfs", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfwp", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibmesa-dri", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibmesa-dri-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibmesa-gl", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibmesa-gl-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibmesa-gl-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibmesa-glu", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibmesa-glu-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibmesa-glu-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibmesa3", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibosmesa-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibosmesa4", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibosmesa4-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibs-static-dev", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibs-static-pic", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xmh", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xnest", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-common", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-xfree86", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-xfree86-dbg", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xterm", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xutils", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xvfb", ver:"4.3.0.dfsg.1-14sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
