// This file is a part of the OpenSurgSim project.
// Copyright 2013, SimQuest Solutions Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/// \file osg_statshandler.frag
/// Under modelview transform and attribute replacement the osg statshandler does not render correctly
/// this vertex shader fixes this problems 

uniform sampler2D osg_TextTexture; 

varying vec4 color; 
varying vec2 textureCoords; 

void main() 
{ 
    vec4 textColor = vec4(1.0, 1.0, 1.0, texture2D(osg_TextTexture, textureCoords).a); 
    gl_FragColor = color * textColor; 
}