// $Id: OSDGUILayer.hh 9404 2009-03-20 21:34:28Z m9710797 $

#ifndef OSDGUILAYER_HH
#define OSDGUILAYER_HH

#include "Layer.hh"

namespace openmsx {

class OSDGUI;

class OSDGUILayer : public Layer
{
public:
	OSDGUI& getGUI();

	// Layer
	virtual const std::string& getName();

protected:
	explicit OSDGUILayer(OSDGUI& gui);
	~OSDGUILayer();

private:
	OSDGUI& gui;
};

class SDLOSDGUILayer : public OSDGUILayer
{
public:
	explicit SDLOSDGUILayer(OSDGUI& gui);

	// Layer
	virtual void paint(OutputSurface& output);
};

class GLOSDGUILayer : public OSDGUILayer
{
public:
	explicit GLOSDGUILayer(OSDGUI& gui);

	// Layer
	virtual void paint(OutputSurface& output);
};

} // namespace openmsx

#endif
