/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License alongCont
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CONTROLMODEL_H
#define CONTROLMODEL_H

#include <string>
#include <list>

using std::string; using std::list;

namespace LibOmClient {

	
/** Class to represent a preset (collection of control settings).
 *
 * \ingroup libomclient
 */
class ControlModel
{
public:
	ControlModel(const string& path, float value)
	: m_port_path(path),
	  m_value(value)
	{
	}
	
	const string& port_path() const            { return m_port_path; }
	void          port_path(const string& p)   { m_port_path = p; }
	float         value() const                { return m_value; }
	void          value(float v)               { m_value = v; }

	inline bool operator==(const ControlModel& cm)
		{ return (m_port_path == cm.m_port_path); }

private:
	string m_port_path;
	float  m_value;
};


} // namespace LibOmClient

#endif // CONTROLMODEL
