/*************************************************
**      To: main.cpp
** Project: nvclock
**  Author: Jan Prokop
**  e-mail: jprokop@ibl.sk
*************************************************/

#include <unistd.h>
#include <sys/types.h>

#include "qt_nvclock.h"

#include <qmessagebox.h>
#include <qapplication.h>

//***********************************************************************

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    if ( getuid() != 0 && geteuid() != 0 && CheckDriver() == 0) {
    	    QMessageBox::warning(0, QObject::tr("Error"),
                         QObject::tr("You don't have access to the registers of your nVidia card.\nRun this program as root or install and load the closed source nVidia drivers!"));
	
        return(1);
    }
    
    CNVclock nv(0, "nv");

    app.setMainWidget(&nv);
    nv.show();
    
    return(app.exec());
}
