/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

int total_cards;

int main (int argc, char *argv[])
{
    GtkWidget *nvclock;

/*#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif
*/

    gtk_set_locale ();
    gtk_init (&argc, &argv);
/*
  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");
*/
  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */

    if ( getuid() != 0 && geteuid() != 0 )
    {
	/*
	Check to see if the NVdriver is loaded.
	If not use /proc to detect cards and /dev/mem
	for overclocking. If the driver is loaded we use
	ioctl's to /dev/nv* since that works for all users.
	*/
	if(CheckDriver() == 0)
	{
	    printf("You don't have permissions to access the registers of your Nvidia card.\n");
	    printf("Try to run nvclock as root to get access to /dev/mem or install the Nvidia 3d drivers to use /dev/nv* instead.\n");
	    printf("Remember only root can access /dev/mem, most users can access /dev/nv*.\n");

	    exit(1);
	}
    
	else
	{
	    total_cards = FindAllCards_ioctl();
	}
    }

    else
    {
	total_cards = FindAllCards_proc();
    }


    nvclock = create_nvclock ();
    gtk_widget_show (nvclock);


    update_info();

    gtk_main ();
    return 0;
}

