#include "version.h"

#include <sys/types.h>

#ifdef WIN32
#define random lbl_random
#define srandom lbl_srandom

#include "search.h"

#define close closesocket
#define MAXHOSTNAMELEN  256
#define _SYS_NMLN       9

typedef int pid_t;
typedef int uid_t;
typedef int gid_t;

#ifndef WIN32
typedef unsigned long time_t;
#endif

int uname(struct utsname *);
int getopt(int, char * const *, const char *);
int strcasecmp(const char *, const char *);
int srandom(int);
int random(void);
int gettimeofday(struct timeval *p, struct timezone *z);   

int gethostid(void);
int getuid(void);
int getgid(void);
int getpid(void);
int nice(int);
int sendmsg(int, struct msghdr*, int);
time_t time(time_t *);

#define ECONNREFUSED    WSAECONNREFUSED
#define ENETUNREACH     WSAENETUNREACH
#define EHOSTUNREACH    WSAEHOSTUNREACH
#define EWOULDBLOCK     WSAEWOULDBLOCK

#define M_PI            3.14159265358979323846
#define MAXINT 0x8fffffff
                                                  
#else
#include <sys/time.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/param.h>
#include <netdb.h>
#include <sys/utsname.h>

#ifndef HAVE_NO_VALUES_H
#include <values.h>
#endif

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/uio.h>
/*#include <net/if.h>*/
#include <sys/ioctl.h>
#include <pwd.h>

#endif

