/*!
 * fill-range <https://github.com/jonschlinkert/fill-range>
 *
 * Copyright (c) 2014-2017, Jon Schlinkert.
 * Released under the MIT License.
 */

'use strict';

require('mocha');
var util = require('util');
var assert = require('assert');
var exact = require('./support/exact');
var fill = require('..');

describe('padding: numbers', function() {
  it('should pad incremented numbers:', function() {
    exact(fill('1', '3'), ['1', '2', '3']);
    exact(fill('01', '03'), ['01', '02', '03']);
    exact(fill('01', '3'), ['01', '02', '03']);
    exact(fill('1', '03'), ['01', '02', '03']);
    exact(fill('0001', '0003'), ['0001', '0002', '0003']);
    exact(fill('-10', '00'), ['-10', '-09', '-08', '-07', '-06', '-05', '-04', '-03', '-02', '-01', '000']);
    exact(fill('05', '010'), ['005','006','007','008','009','010']);
    exact(fill('05', '100'), ['005','006','007','008','009','010','011','012','013','014','015','016','017','018','019','020','021','022','023','024','025','026','027','028','029','030','031','032','033','034','035','036','037','038','039','040','041','042','043','044','045','046','047','048','049','050','051','052','053','054','055','056','057','058','059','060','061','062','063','064','065','066','067','068','069','070','071','072','073','074','075','076','077','078','079','080','081','082','083','084','085','086','087','088','089','090','091','092','093','094','095','096','097','098','099','100']);
  });

  it('should pad decremented numbers:', function() {
    exact(fill('03', '01'), ['03', '02', '01']);
    exact(fill('3', '01'), ['03', '02', '01']);
    exact(fill('003', '1'), ['003', '002', '001']);
    exact(fill('003', '001'), ['003', '002', '001']);
    exact(fill('3', '001'), ['003', '002', '001']);
    exact(fill('03', '001'), ['003', '002', '001']);
  });

  it('should pad stepped numbers', function() {
    exact(fill('1', '05', '3'), ['01','04']);
    exact(fill('1', '005', '3'), ['001','004']);
    exact(fill('00', '1000', '200'), ['0000','0200', '0400', '0600', '0800', '1000']);
    exact(fill('0', '01000', '200'), ['00000','00200', '00400', '00600', '00800', '01000']);
    exact(fill('001', '5', '3'), ['001','004']);
    exact(fill('02', '10', 2), ['02', '04', '06', '08', '10']);
    exact(fill('002', '10', 2), ['002', '004', '006', '008', '010']);
    exact(fill('002', '010', 2), ['002', '004', '006', '008', '010']);
    exact(fill('-04', 4, 2), ['-04', '-02', '000', '002', '004']);
  });
});
