
/*
 * folder_free.c -- free a folder/message structure
 *
 * $Id: folder_free.c,v 1.2 2002/07/02 22:09:14 kenh Exp $
 *
 * This code is Copyright (c) 2002, by the authors of nmh.  See the
 * COPYRIGHT file in the root directory of the nmh distribution for
 * complete copyright information.
 */

#include <h/mh.h>


void
folder_free (struct msgs *mp)
{
    int i;

    if (!mp)
	return;

    if (mp->foldpath)
	free (mp->foldpath);

    /* free the sequence names */
    for (i = 0; mp->msgattrs[i]; i++)
	free (mp->msgattrs[i]);

    free (mp->msgstats);	/* free message status area   */
    free (mp);			/* free main folder structure */
}
