/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.OutPort;

public class IncrementExp
extends Expression {
    Declaration decl;
    private short increment;
    private boolean pre;

    public IncrementExp(Declaration decl, short increment, boolean pre) {
        this.decl = decl;
        this.increment = increment;
        this.pre = pre;
    }

    @Override
    public void compile(Compilation comp, Target target) {
        boolean needValue;
        CodeAttr code = comp.getCode();
        boolean bl = needValue = !(target instanceof IgnoreTarget);
        if (this.decl.isSimple()) {
            Variable var = this.decl.getVariable();
            if (!this.pre && needValue) {
                code.emitLoad(var);
            }
            if (var.getType() == Type.int_type) {
                code.emitInc(var, this.increment);
            } else {
                PrimType type = var.getType() == Type.long_ctype ? Type.long_type : Type.int_type;
                code.emitLoad(var);
                StackTarget.getInstance(type).compileFromStack(comp, var.getType());
                code.emitPushConstant(this.increment, type);
                code.emitAdd(type);
                StackTarget.getInstance(var.getType()).compileFromStack(comp, type);
                code.emitStore(var);
            }
            if (this.pre && needValue) {
                code.emitLoad(var);
            }
        } else {
            PrimType type;
            Field field = this.decl.field;
            boolean isStatic = field.getStaticFlag();
            if (isStatic) {
                code.emitGetStatic(field);
            } else {
                this.decl.loadOwningObject(comp);
                code.emitDup();
                code.emitGetField(field);
            }
            boolean isLong = field.getType().getSize() > 4;
            PrimType primType = type = isLong ? Type.long_type : Type.int_type;
            if (!this.pre && needValue) {
                if (isStatic) {
                    code.emitDup();
                } else {
                    code.emitDupX();
                }
            }
            if (isLong) {
                code.emitPushLong(this.increment);
            } else {
                code.emitPushInt(this.increment);
            }
            code.emitAdd(type);
            if (this.pre && needValue) {
                if (isStatic) {
                    code.emitDup();
                } else {
                    code.emitDupX();
                }
            }
            if (isStatic) {
                code.emitPutStatic(field);
            } else {
                code.emitPutField(field);
            }
        }
        if (needValue) {
            target.compileFromStack(comp, this.getType());
        }
    }

    @Override
    public Type getType() {
        return this.decl.getType();
    }

    @Override
    protected Expression walk(ExpWalker w) {
        return w.walkIncrementExp(this);
    }

    @Override
    public void print(OutPort out) {
        out.startLogicalBlock("(Increment", ")", 2);
        if (this.decl == null) {
            out.print("<null declaration>");
        } else {
            out.print(this.decl.getName());
        }
        out.endLogicalBlock(")");
    }
}

