/*
 * Decompiled with CFR 0.152.
 */
package bossa.modules;

import bossa.modules.CompiledContent;
import bossa.modules.Content;
import bossa.modules.Package;
import bossa.util.Located;
import bossa.util.User;
import gnu.bytecode.ClassFileInput;
import gnu.bytecode.ClassType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import nice.tools.util.System;

class JarCompiledContent
extends CompiledContent {
    private Package pkg;
    private JarFile jar;
    private JarEntry itfEntry;
    private JarEntry bytecodeEntry;
    private JarEntry dispatchEntry;

    static JarCompiledContent create(Package pkg, JarFile jar) {
        String pkgName = pkg.getName().replace('.', '/');
        JarEntry itfEntry = jar.getJarEntry(pkgName + "/package.nicei");
        if (itfEntry == null) {
            return null;
        }
        JarEntry bytecodeEntry = jar.getJarEntry(pkgName + "/" + "fun" + ".class");
        if (bytecodeEntry == null) {
            return null;
        }
        JarEntry dispatchEntry = jar.getJarEntry(pkgName + "/dispatch.class");
        if (dispatchEntry == null) {
            return null;
        }
        return new JarCompiledContent(pkg, jar, itfEntry, bytecodeEntry, dispatchEntry);
    }

    JarCompiledContent(Package pkg, JarFile jar, JarEntry itfEntry, JarEntry bytecodeEntry, JarEntry dispatchEntry) {
        this.pkg = pkg;
        this.jar = jar;
        this.itfEntry = itfEntry;
        this.bytecodeEntry = bytecodeEntry;
        this.dispatchEntry = dispatchEntry;
        this.lastCompilation = Math.min(itfEntry.getTime(), Math.min(bytecodeEntry.getTime(), dispatchEntry.getTime()));
        this.lastCompilation = Math.max(new File(jar.getName()).lastModified(), this.lastCompilation);
    }

    @Override
    Content.Unit[] getDefinitions() {
        BufferedReader res = null;
        try {
            res = new BufferedReader(new InputStreamReader(this.jar.getInputStream(this.itfEntry)));
            this.bytecode = ClassFileInput.readClassType(this.jar.getInputStream(this.bytecodeEntry));
            this.dispatch = ClassFileInput.readClassType(this.jar.getInputStream(this.dispatchEntry));
        }
        catch (IOException e) {
            User.error((Located)this.pkg.name, "Error reading archive " + this.getName());
        }
        return new Content.Unit[]{new Content.Unit(res, this.pkg.name.toString())};
    }

    @Override
    ClassType readClass(String name) {
        JarEntry entry = this.jar.getJarEntry(name.replace('.', '/') + ".class");
        if (entry == null) {
            return null;
        }
        try {
            return ClassFileInput.readClassType(name, this.jar.getInputStream(entry));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    void addClasses(Set classes) {
        String pkgPrefix = this.pkg.getName().replace('.', '/') + "/";
        Enumeration<JarEntry> en = this.jar.entries();
        while (en.hasMoreElements()) {
            JarEntry e = en.nextElement();
            String fullname = e.getName();
            if (!fullname.startsWith(pkgPrefix) || fullname.indexOf(47, pkgPrefix.length()) != -1 || !fullname.endsWith(".class")) continue;
            String name = fullname.substring(pkgPrefix.length());
            try {
                classes.add(new Content.Stream(this.jar.getInputStream(e), name));
            }
            catch (IOException ex) {
                User.error((Located)this.pkg.name, "Error reading archive " + this.getName());
            }
        }
    }

    InputStream getBytecodeStream() {
        try {
            return this.jar.getInputStream(this.bytecodeEntry);
        }
        catch (IOException e) {
            User.error((Located)this.pkg, "Error reading archive " + this.getName());
            return null;
        }
    }

    @Override
    public String getName() {
        return System.prettyPrint(this.jar);
    }

    @Override
    public String toString() {
        return "Compiled package: " + this.getName();
    }
}

