/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.Procedure2;
import java.lang.reflect.Field;

public class SetFieldProc
extends Procedure2
implements Inlineable {
    private Declaration fieldDecl;

    public SetFieldProc(Declaration fieldDecl) {
        this.fieldDecl = fieldDecl;
        if (fieldDecl == null) {
            throw new NullPointerException();
        }
    }

    public Object apply2(Object arg1, Object arg2) {
        gnu.bytecode.Field field = this.fieldDecl.field;
        try {
            Field reflectField = field.getReflectField();
            arg2 = field.getType().coerceFromObject(arg2);
            reflectField.set(arg1, arg2);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException("no such field " + field.getSourceName() + " in " + field.getDeclaringClass().getName());
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("illegal access for field " + field.getSourceName());
        }
        return arg2;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        gnu.bytecode.Field field = this.fieldDecl.field;
        Type fieldType = field.getType();
        Expression[] args = exp.getArgs();
        CodeAttr code = comp.getCode();
        boolean ignore = target instanceof IgnoreTarget;
        ClassType ctype = field.getDeclaringClass();
        args[0].compile(comp, ctype);
        args[1].compile(comp, fieldType);
        if (!ignore) {
            code.emitDup(fieldType.getSize() > 4 ? 2 : 1, 1);
        }
        code.emitPutField(field);
        if (!ignore) {
            target.compileFromStack(comp, fieldType);
        }
    }

    public Type getReturnType(Expression[] args) {
        return this.fieldDecl.getType();
    }
}

