(* $Id: netstring_str.mli,v 1.2 2000/06/25 21:15:48 gerd Exp $
 * ----------------------------------------------------------------------
 *
 *)

(* This module is a version of Str with a thread-safe interface *)

type regexp = Str.regexp;;
type split_result = Str.split_result = Text of string | Delim of string;;

type result;;
  (* The type of matching results *)

val regexp: string -> regexp
val regexp_case_fold: string -> regexp
val quote: string -> string
val regexp_string: string -> regexp
val regexp_string_case_fold: string -> regexp

val string_match: 
      ?groups:int -> regexp -> string -> int -> result option
val search_forward: 
      ?groups:int -> regexp -> string -> int -> (int * result)
val search_backward: 
      ?groups:int -> regexp -> string -> int -> (int * result)
val string_partial_match: 
      ?groups:int -> regexp -> string -> int -> result option

(* The ~groups option specifies how many groups will be stored into
 * 'result'. Default: 9
 *)

val matched_string : result -> string -> string
val match_beginning : result -> int
val match_end : result -> int
val matched_group : result -> int -> string -> string
val group_beginning : result -> int -> int
val group_end : result -> int -> int

val global_replace: regexp -> string -> string -> string
val replace_first: regexp -> string -> string -> string
val global_substitute:
       ?groups:int -> 
       regexp -> (result -> string -> string) -> string -> string
val substitute_first:
       ?groups:int -> 
       regexp -> (result -> string -> string) -> string -> string

(* replace_matched: not available *)

val split: regexp -> string -> string list
val bounded_split: regexp -> string -> int -> string list
val split_delim: regexp -> string -> string list
val bounded_split_delim: regexp -> string -> int -> string list
val full_split: regexp -> string -> split_result list
val bounded_full_split: regexp -> string -> int -> split_result list

val string_before: string -> int -> string
val string_after: string -> int -> string
val first_chars: string -> int -> string
val last_chars: string -> int -> string

(* Private: *)

val init_mt : (unit -> unit) -> (unit -> unit) -> unit


(* ======================================================================
 * History:
 * 
 * $Log: netstring_str.mli,v $
 * Revision 1.2  2000/06/25 21:15:48  gerd
 * 	Checked thread-safety.
 *
 * Revision 1.1  2000/06/25 20:48:19  gerd
 * 	Initial revision.
 *
 * 
 *)
