/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  romlib.h
 * Purpose: Header file for interfacing with the C library functions
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * Special characters from ASCII character set:
 */
#define CHR_BS		'\010'
#define CHR_LF		'\012'
#define CHR_FF		'\014'
#define CHR_CR		'\015'
#define CHR_STOP	'\023'
#define CHR_ESC		'\033'



/*
 **************************************************************************
 *
 * I/O functions:
 */
extern int getkey __P((int timeout));		/* wait for key input	*/
extern int chkkey __P((void));			/* check if key pressed	*/
extern void printf __P((char *format, ...));	/* print formatted str	*/



/*
 **************************************************************************
 *
 * Time related functions:
 */
extern void set_timeout __P((int ticks));	/* set timeout ticks	*/
extern int chk_timeout __P((void));		/* timeout reached	*/
extern unsigned long get_ticks __P((void));	/* get timer ticks	*/



/*
 **************************************************************************
 *
 * String and memory handling functions:
 */
extern void memcpy __P((void *b1, void *b2, int length));
extern int  memcmp __P((void *b1, void *b2, int length));
extern void memset __P((void *b, int c, int length));



/*
 **************************************************************************
 *
 * Miscellaneous routines:
 */
extern void fatal __P((void));			/* terminate boot rom	*/
extern unsigned int getds __P((void));		/* get current data seg	*/
extern short int random __P((void));		/* get random value	*/
extern int memavail __P((void));		/* get avail mem size	*/
extern unsigned long far2long __P((unsigned long ptr));
extern unsigned long long2far __P((unsigned long l));

