!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  misc.S
!* Purpose: Routines for different things
!* Entries: _random, _far2long, _long2far, _getds, _fatal, _memavail,
!*          prnstr, prnword, prnbyte
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! Include assembler macros:
!
#include <macros.inc>
#include <memory.inc>
#include "./libpriv.inc"


!
!**************************************************************************
!
! Definitions for the random number generator:
!
RANDLOW		equ	$4E35		! Low multiplication value
RANDHIGH	equ	$015A		! High multiplication value
RANDMUL		equ	$015A4E35	! everything together for 386
RANDADD		equ	23968


!
!**************************************************************************
!
! Define BIOS entry point for rebooting the system.
!
BOOTSEG		equ	$FFFF


!
!**************************************************************************
!
! BSS segment:
!
	.bss

	.lcomm	rseed,4			! seed for random number


!
!**************************************************************************
!
! Start code segment.
!
	.text

	public	_random			! define entry points
	public	_far2long
	public	_long2far
	public	_memavail
	public	_getds
	public	_fatal
	public	prnstr
	public	prnword
	public	prnbyte
	public	prnchar

	extrn	_get_ticks


!
!**************************************************************************
!
! Return a integer random number
! Input:  none
! Output: random number
!
_random:

#ifdef IS386
	mov	eax,rseed		! check if the seed has already been
	or	eax,eax			! set
#else
	mov	dx,word ptr [rseed+0]
	mov	ax,dx			! check if the seed has already been
	or	dx,word ptr [rseed+2]	! set
#endif
	jnz	rand1			! if not set it by reading the timer
	call	near _get_ticks		! tick count
#ifdef OPT386
	mov	[rseed],eax
#else
	mov 	word ptr [rseed+0],ax
	mov	word ptr [rseed+2],dx
#endif

rand1:
#ifdef IS386
	mov	eax,#RANDMUL		! multiply the seed with a magic number
	mul	dword ptr rseed
	add	eax,#RANDADD		! add another magic number
	shr	eax,#1			! shift number right one bit
	mov	rseed,eax		! save new seed
	and	eax,#$7FFF		! prepare return value
#else
	mov	dx,#RANDHIGH
	mul	dx			! multiply the seed with a magic number
	mov	bx,ax
	mov	ax,#RANDLOW
	mul	word ptr [rseed+0]
	mov	cx,ax
	add	bx,dx
	mov	ax,#RANDLOW
	mul	word ptr [rseed+2]
	add	bx,ax
	add	cx,#RANDADD		! add another magic number
	adc	bx,#0
	shr	bx,#1			! shift number right one bit
	rcr	cx,#1
	mov	word ptr [rseed+0],cx	! save new seed number
	mov	word ptr [rseed+2],bx
	mov	ax,bx			! prepare return value
	and	ax,#$7FFF		! make it a signed integer
#endif
	ret


!
!**************************************************************************
!
! Convert far pointer into linear long number
! Input:  1. Arg  -  far pointer
! Output: linear address
!
_far2long:

	penter
#ifdef OPT386
	getlarg	(eax,0,word)		! get far pointer
	getlarg	(edx,1,word)
	shl	edx,#4
	add	eax,edx
#else
	getcarg	(dx,1)			! get far pointer
	getcarg	(ax,0)
	mov	bx,dx
	shift	(shr,dx,12)		! convert into linear address
	shift	(shl,bx,4)
	add	ax,bx
	adc	dx,#0
#endif
	pleave
	ret


!
!**************************************************************************
!
! Convert linear long number into far pointer
! Input:  1. Arg  -  long linear address
! Output: far pointer
!
_long2far:

	penter
#ifdef OPT386
	getcarg	(eax,0)			! get long number
	shl	eax,#12			! convert into far pointer
	shr	ax,#12
#else
	getcarg	(dx,1)			! get long number
	getcarg	(ax,0)
	mov	bx,ax
	and	ax,#$000F
	shift	(shr,bx,4)		! convert into far pointer
	shift	(shl,dx,12)
	add	dx,bx
#endif
	pleave
	ret


!
!**************************************************************************
!
! Determine amount of free memory in kB.
! Input:  none
! Output: memory size
!
_memavail:

	mov	ah,#$48
	mov	bx,#$FFFF		! determine amount of free memory
	int	$21			! should always return with carry
	shift	(shr,bx,6)		! convert into kB
	mov	ax,bx
	ret


!
!**************************************************************************
!
! Return data segment.
! Input:  none
! Output: data segment
!
_getds:
	mov	ax,ds
	ret


!
!**************************************************************************
!
! Handle fatal errors
! Input:  none
! Output: none
!
_fatal:

	mov	bx,#fatmsg
	call	prnstr			! print startup message
	xor	ax,ax
	int	$16			! wait for key press

	cli
	xor	ax,ax
	mov	ds,ax
	mov	word ptr [$0472],#$1234	! indicates warm boot
	jmpi	0,BOOTSEG		! reboot the system

! Error messages

fatmsg:	.byte	$0D,$0A,$0D,$0A
	.asciz	"Press a key to reboot..."


!
!**************************************************************************
!
! Print a string onto the console screen.
! Input:  CS:BX  -  pointer to zero terminated string
! Output: none
! Registers changed: AX, BX
!
prnstr:

prnst1:	seg	cs
	mov	al,[bx]
	or	al,al			! end of string
	jz	prnst2
	call	prnchar			! print character
	inc	bx			! proceed with next character
	jmp	prnst1
prnst2:	ret


!
!**************************************************************************
!
! Print a word/byte/nibble onto the console screen
! Input:  AX  -  value
! Output: none
! Registers changed: AX
!
prnword:

	push	ax
	mov	al,ah
	call	prnbyte			! print high word
	pop	ax			! print low word

prnbyte:

	push	ax
#ifdef IS186
	shr	al,#4
#else
	shr	al,#1
	shr	al,#1			! print high nibble
	shr	al,#1
	shr	al,#1
#endif
	call	prnnibble
	pop	ax			! print low nibble

prnnibble:

	and	al,#$0F
	add	al,#$30			! convert into ASCII character
	cmp	al,#$39
	jbe	prnchar
	add	al,#7

prnchar:

	push	bx
	mov	ah,#$0E			! dont use int 29h here, because this
	xor	bh,bh			! routine might be called before int $29
	int	$10			! has been setup. use the BIOS directly.
	pop	bx
	ret


!
!**************************************************************************
!
	end

