#TRUSTED 6c80c60fcba13f8236a3acae0ffb1a941ce973c30f206fcbe5ee75b0f033c45835b0123320aef6a18d71ebd3ac354301f0f9fa607e1f6b4523fca3f6b8a6e4e9ac89c1dc06a123fd5d51fe257b96ea6e958901142f9321f09c78e1b679796861d90dc34bf194f5d7ffa9b1eba926a16e07c25435ea13194920e6f65028f39d220227ddf12af3f4437a6640dae14018d596a5f69afd1ac49d7b9ae991786ccd94ee0347b9b5fe5d2019036eb160e808482042c1c598ef792bb7dac1ac8ccc172d0ec6a653fa72e22559732a654301c509121bdf373ee4930462ed6ea1c0a7653f259c97531f8c0e1212e8f178340cd78667875814431a8ad541748b819b1b0eb0a5ca94c7384b8f2b1c23e80f1604708c3be6cda4e5e0eea76a046bf3a51c4d7318aa11aa88ad721fa2d08d94e8336c7b359dcc5b596c192c10e7e788cf4f87e7ea745dcb63bb5ca3d42fcbc98cbe9333a3ca8e95d624837e92e0f85fabb2604e9616a0ee268beb4dea6b8585bc962040558d1257aa3ae9e8d77487b5194df77769bc5a2bd53d6ba340efcf809f77d93c50af2f818015354b4b2bd268216d572ad456ac91fbd63a8689066c30e9dd6c3c3d00a7a060739fe9b3a8eabe8527eb6e89dcdde8432881017e5d9e29611a50a48a1777d760269ea18e38fa8480598e3b45a29b89ced85e5c297362661b5eba14325c1a29640bad699bc45ad7c7d53ccd
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if ( ! defined_func("script_get_preference_file_location")) exit(0);
if ( ! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15884);
 script_version ("1.3");
 name["english"] = "Hydra: SMB";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SMB accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SMB authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_add_preference(name: "Check local / domain accounts", 
	value: "Local accounts; Domain Accounts; Either", type: "radio");
 script_add_preference(name: "Interpret passwords as NTLM hashes", 
	value: "no", type: "checkbox");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports(139, 445, "SMB/transport");
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "doublecheck_std_services.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
 if (! safe_checks()) exit(0); # Because of accounts lock out
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("SMB/transport"); port = int(port);
if (! port) exit(0);	# port = 445;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;

s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "smbnt";	# what's "smb"?

opt = "";
p = script_get_preference("Check local / domain accounts");
if ("Local" >< p) opt = "L";
else if ("Domain" >< p) opt = "D";
else opt = "B";

p = script_get_preference("Interpret passwords as NTLM hashes");
if ("yes" >< p) opt += "H";
argv[i++] = opt;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SMB accounts:\n' + report);
