#TRUSTED 943145f197494a6a7b9f9f68ffa609665cc1bb264e73a832de850d4248c1a0eb6def0fdddef350ccf99444e35f6d5143e0cc03cc24b7ea4f438df786090202a25ad19daf8669984399bde82e449adc78ef5ffb82023c87c82d9341d81e97a55184710192859347068bc9eda50d677606c1df178f4efa9d32217dc7851c0a424fe3d3db54644bace47be1689fba548cd37b54489cbb83fc6911802fb2a4e7f83dd0fcb64815d79a6e19004d68fbfcb9f3b91f0a637ac642bcf2a5adcbbafbb243c0dcf21056a648b9aa646e4e3c0b240a59be2753e83b8d5d03f6afb6caf901d4a02199f3e120e5b33a5e53c43ccffdcb588da7534d689fe0eeb705d3b481eae67861faf29759a5e13af0d098b3446fcce013353b555c989e80d273346926ab577073f92ffa41b04e7cc92a319edc21ed79740a5c29d710fcdd26896f6f2d7230781626b9ef5e6427ddee02b39da45f15e479a5b06294387a21f8d83d96055e6b23c42ede757236f0722b0500750808088d76071b9d66482668980e2dc24de9d117216e76644c74f56c1a80d1dd9225aa052a616e58f0469fcf4acd79e0892100eb3c1d5ac9097d17783e39e0a140c942aea637ec77de9147731b470de221229c3244fabdee76dc4c1467d6ceb6bebd70a5ae8e356b3f1fe2c55490a30e0fc99818d9ec96813ab4844a0855a77e590830c974e49d174e8d73dda075093ea40dac
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15874);
 script_version ("1.3");
 name["english"] = "Hydra: HTTP proxy";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find HTTP proxy accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force HTTP proxy authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_add_preference(name: "Web site (optional) :", value: "", type: "entry");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/http_proxy", 3128);
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "doublecheck_std_services.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/http_proxy");
if (! port) exit(0); # port = 3128;
if (! get_port_state(port)) exit(0);

# www.suse.com by default
opt = script_get_preference("Site (optional) :");
if (!opt) site = 'http://www.suse.com/';
else if (opt !~ '^(http|ftp)://') site = strcat('http://', opt);
else site = opt;
host = ereg_replace(string: site, pattern: '^(ftp|http://)([^/]+@)?([^/]+)/.*',
	replace: "\3");
if (host == site)
 req = 'GET '+site+' HTTP/1.0\r\n\r\n';
else
 req = 'GET '+site+' HTTP/1.1\r\nHost: '+host+'\r\n\r\n';
s = open_sock_tcp(port);
if (!s) exit(0);
send(socket: s, data: req);
r = recv_line(socket: s, length: 1024);
close(s);
if (r =~ "^HTTP/1\.[01] +[234]0[0-9] ") exit(0);	# Proxy is not protected

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (!s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "http-proxy";

if (opt) argv[i++] = opt;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/http-proxy/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following accounts on the HTTP proxy:\n' + report);
