#
# This script was written by Matt Moore <matt.moore@westpoint.ltd.uk>
# www.westpoint.ltd.uk
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10767);
 name["english"] = "Tests for Nimda Worm infected HTML files";
 name["francais"] = "Tests for Nimda Worm infected HTML files";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "Your server appears to have been compromised by the 
Nimda mass mailing worm.It uses various known IIS vulnerabilities to 
compromise the server.

Anyone visiting compromised Web servers will be prompted to download an .eml 
(Outlook Express) email file, which contains the worm as an attachment. 

Also, the worm will create open network shares on the infected computer, 
allowing access to the system. During this process the worm creates the 
guest account with Administrator privileges.

Solution: Take this server offline immediately and rebuild it.

Risk Factor: High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Tests for Nimda Worm infected HTML files";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2001 Matt Moore",
		francais:"Ce script est Copyright (C) 2001 Matt Moore");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

# Check for references to readme.eml in default HTML page..

port = get_kb_item("Services/www");
if(!port)port = 80;
if(get_port_state(port))
{ 
 req = http_get(item:"/", port:port);
 soc = http_open_socket(port);
 if(soc)
 {
 send(socket:soc, data:req);
 r = recv(socket:soc, length:102400);
 close(soc);
 if("readme.eml" >< r)	
 	security_hole(port);

 
 }
}
