#
# Copyright 2000 by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#
#

if(description)
{
 script_id(10755);

 name["english"] = "Microsoft Exchange Public Folders Information Leak";
 script_name(english:name["english"]);

 desc["english"] = "Microsoft Exchange Public Folders can be set to allow anonymous connections (set by default). If this is not changed it is possible for
an attacker to gain critical information about the users (such as full email address, phone number, etc) that are present in the Exchange Server.

Risk factor : Medium

Additional information:
http://www.securiteam.com/windowsntfocus/5WP091P5FQ.html
";

 script_description(english:desc["english"]);

 summary["english"] = "Microsoft Exchange Public Folders Information Leak";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2001 SecuriTeam");
 family["english"] = "General";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = is_cgi_installed("/exchange/root.asp");
if (port)
{
 Host = "";
 if (get_host_name())
 {
  Host = get_host_name();
 }
 else
 {
  Host = get_host_ip();
 } 

 #display(Host, "\n");
 if (Host)
 {
  first = string("GET /exchange/root.asp?acs=anon HTTP/1.1\nHost: ",Host, "\n\n");

  soctcp80 = open_sock_tcp(port);
  if (soctcp80)
  {
   send(socket:soctcp80, data:first);
   result = recv(socket:soctcp80, length:8196);

   SetCookie = 0;
   #display(result);
   
   if (("HTTP/1.1 200 OK" >< result) && ("Set-Cookie: " >< result) && ("top.location='/exchange/logonfrm.asp'" >< result))
   {
    #display("Done First step\n");

    SetCookie = strstr(result, "Set-Cookie: ");
    resultsub = strstr(SetCookie, "; path=/");
    SetCookie = SetCookie - "Set-Cookie: ";
    SetCookie = SetCookie - resultsub;

    #display("Cookie: ", SetCookie, "\n");

    second = string("GET /exchange/logonfrm.asp HTTP/1.1\nHost: ", Host, "\nCookie: ", SetCookie, "\n\n");

    send(socket:soctcp80, data:second);
    result = recv(socket:soctcp80, length:8196);
    #display(result);

    if (("HTTP/1.1 302 Object moved" >< result) && ("Location: /exchange/root.asp?acs=anon" >< result))
    {
     #display("Done Second step\n");

     third = string("GET /exchange/root.asp?acs=anon HTTP/1.1\nHost: ", Host, "\nCookie: ", SetCookie, "\n\n");

     send(socket:soctcp80, data:third);
     result = recv(socket:soctcp80, length:8196);
     #display(result);

     if (("HTTP/1.1 200 OK" >< result) && ("/exchange/Navbar/nbAnon.asp" >< result))
     {
      #display("Done Third step\n");

      final = string("POST /exchange/finduser/fumsg.asp HTTP/1.1\nHost: ", Host, "\nAccept: */*\nContent-Type: application/x-www-form-urlencoded\nContent-Length: 44\nCookie: ", SetCookie, "\n\nDN=a&FN=&LN=&TL=&AN=&CP=&DP=&OF=&CY=&ST=&CO=");

      send(socket:soctcp80, data:final);
      result = recv(socket:soctcp80, length:8196);
      #display(result);
      if (("HTTP/1.1 200 OK" >< result) && (("details.asp?obj=" >< result) || ("This query would return" >< result)) )
      {
       security_hole(port:port);
      }
     }
    }
   }
  }
 }
}
