unit CommonFuncs;

interface

uses
  gnugettext, SysUtils, Options, AuxFuncs, Windows, Forms, About,
  TntSystem;

procedure CheckCommonCommandlineParameter;
procedure ShowAboutDialog(Caption: WideString;
  Version: WideString; Credits: WideString);

implementation

procedure CheckCommonCommandlineParameter;

var
  i: integer;
  S: string;
  
begin
  for i := 1 to WideParamCount do
  begin
    //-------------------------------------------------------------
    //General cmdline parameters

    S := WideParamStr(I);

    //Connection
    if (S = '-c') and (I+1 <= WideParamCount) then
      MYXCommonOptions.ConnectionToUse := WideParamStr(I + 1)
    else
      if (Copy(S, 1, 2) = '-c') then
        MYXCommonOptions.ConnectionToUse := Copy(S, 3, MaxInt)
      else
        //Username
        if ((S = '-u')) and (I+1 <= WideParamCount) then
          MYXCommonOptions.ConnectionUsername := WideParamStr(I + 1)
        else
          if (Copy(S, 1, 2) = '-u') then
            MYXCommonOptions.ConnectionUsername := Copy(S, 3, MaxInt)
          else
            //Password
            if (S = '-p') and (I+1 <= WideParamCount) then
              MYXCommonOptions.ConnectionPassword := WideParamStr(I + 1)
            else
              if (Copy(S, 1, 2) = '-p') then
                MYXCommonOptions.ConnectionPassword := Copy(S, 3, MaxInt)
              else
                //Host
                if (S = '-h') and (I+1 <= WideParamCount) then
                  MYXCommonOptions.ConnectionHost := WideParamStr(I + 1)
                else
                  if (Copy(S, 1, 2) = '-h') then
                    MYXCommonOptions.ConnectionHost := Copy(S, 3, MaxInt)
                  else
                    //Port
                    if (S = '-P') and (I+1 <= WideParamCount) then
                      MYXCommonOptions.ConnectionPort := WideParamStr(I + 1)
                    else
                      if (Copy(S, 1, 2) = '-P') then
                        MYXCommonOptions.ConnectionPort := Copy(S, 3, MaxInt)
                      else
                        //Schema
                        if (S = '-D') and (I+1 <= WideParamCount) then
                          MYXCommonOptions.ConnectionSchema := WideParamStr(I + 1)
                        else
                          if (Copy(S, 1, 2) = '-D') then
                            MYXCommonOptions.ConnectionSchema := Copy(S, 3, MaxInt);
  end;

  //If only username was specified, automaticly set
  //other connection values
  if (MYXCommonOptions.ConnectionUsername <> '') then
  begin
    if (MYXCommonOptions.ConnectionHost = '') then
      MYXCommonOptions.ConnectionHost := 'localhost';

    if (MYXCommonOptions.ConnectionPort = '') then
      MYXCommonOptions.ConnectionPort := '3306';
  end;
end;

procedure ShowAboutDialog(Caption: WideString;
  Version: WideString; Credits: WideString);
var
  AboutForm: TAboutForm;
begin
  AboutForm := TAboutForm.Create(nil);
  try
    AboutForm.Caption := _('About ') + Caption;
    AboutForm.VersionLbl.Caption := _('version') + ' ' + Version;
    AboutForm.TextLbl.Caption := Credits;
    AboutForm.ShowModal;
  finally
    AboutForm.Free;
  end;
end;

end.

