package com.mysql.grt;

/**
 * @author Mike
 *
 */
public class GrtObjectDataGlobalAux {
	
	protected String globalObjectPath;
	
	public GrtObjectDataGlobalAux(String globalObjectPath) {
		this.globalObjectPath = globalObjectPath;
	}

	protected String getGlobalObjectPath() {
		return globalObjectPath;
	}

	protected String getGrtGlobalAsString(String memberName) {
		return Grt.getInstance().getGrtGlobalAsString(
				getGlobalObjectPath() + "/" + memberName);
	}

	protected int getGrtGlobalAsInt(String memberName) {
		return Grt.getInstance().getGrtGlobalAsInt(
				getGlobalObjectPath() + "/" + memberName);
	}

	protected double getGrtGlobalAsReal(String memberName) {
		return Grt.getInstance().getGrtGlobalAsReal(
				getGlobalObjectPath() + "/" + memberName);
	}

	protected Object getGrtGlobalAsObject(String memberName) {
		return Grt.getInstance().getGrtGlobalAsObject(
				getGlobalObjectPath() + "/" + memberName);
	}

	protected void setGrtGlobalFromString(String memberName, String value) {
		Grt.getInstance().setGrtGlobalFromString(
				getGlobalObjectPath() + "/" + memberName, value);
	}

	protected void setGrtGlobalFromInt(String memberName, int value) {
		Grt.getInstance().setGrtGlobalFromInt(
				getGlobalObjectPath() + "/" + memberName, value);
	}

	protected void setGrtGlobalFromReal(String memberName, double value) {
		Grt.getInstance().setGrtGlobalFromReal(
				getGlobalObjectPath() + "/" + memberName, value);
	}

	protected void setGrtGlobalFromObject(String memberName, Object value) {
		Grt.getInstance().setGrtGlobalFromObject(
				getGlobalObjectPath() + "/" + memberName, value);
	}	
}
