/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef myx_grt_gc_public_interface_h
#define myx_grt_gc_public_interface_h

#if defined(__WIN__) || defined(_WIN32) || defined(_WIN64)
#define __LCC__
#endif

#include <stdio.h>
#include <myx_gc.h>
#include <myx_gc_canvas.h>

#ifdef __cplusplus
extern "C" {   
#endif /* __cplusplus */

#if defined(__WIN__) || defined(_WIN32) || defined(_WIN64)
#define MYX_PUBLIC_FUNC __declspec(dllexport)
#else
#define MYX_PUBLIC_FUNC
#endif

/*
 * PUBLIC INTERFACE definition for MYSQLLibInterfaceMapper
 */

/// [SCRIPT::LibInterfaceMapper] -public_interface "libmysqlgrtgcmodule"
#define libmysqlgrtgcmodule_PUBLIC_INTERFACE_VERSION 10000

/// [SCRIPT::LibInterfaceMapper] -add_to_uses "myx_grt_public_interface"
/// [SCRIPT::LibInterfaceMapper] -add_datatypes_from "..\..\library\include\myx_public_interface.h"

/*
 * Defines
 */

/*
 * Enums
 */

/*
 * Structs and Enums
 */


/*
 * Functions
 */

MYX_PUBLIC_FUNC MYX_GRT_ERROR myx_register_grt_gc_module(MYX_GRT *Runtime);
MYX_PUBLIC_FUNC void myx_unregister_grt_gc_module(MYX_GRT* Runtime);

MYX_PUBLIC_FUNC void myx_grt_gc_bridge_initialize(MYX_GRT *Runtime, CGenericCanvas *Canvas, const char *Path);
MYX_PUBLIC_FUNC void myx_grt_gc_bridge_free(MYX_GRT *Runtime, CGenericCanvas *Canvas, const char *Path);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
