
function run_test(name_test_file,format,name_result)
{
  fso.GetFile(name_test_file).Copy("in.xml")
  shell.Run("Debug\\test_xml.exe " + format,0,true)
  fso.GetFile("in.xml").Delete()
  if (fso.FileExists(name_result))
    fso.GetFile(name_result).Delete()
  if (fso.FileExists("out.xml"))
    fso.GetFile("out.xml").Move(name_result)
}

function check(format,test_name,test_prompt)
{
  var name_found=     format + "_" + test_name
  var name_test_file= ".\\t\\" + name_found + ".test.xml"
  var name_prefix=    ".\\r\\" + name_found
  var name_result=    name_prefix + ".result.xml"
  var name_etalon=    name_prefix + ".result.etalon.xml"
  var name_diff=      name_prefix + ".result.diff"

  run_test(name_test_file,format,name_result)

  var fc_result= compare_results(name_etalon,name_result,name_diff)
  print_test_res(test_prompt,fc_result)
}

function check_idempotency(format,test_name,test_prompt)
{
  var name_found=     format + "_" + test_name
  var name_prefix=    ".\\r\\" + name_found
  var name_test_file= name_prefix + ".result.etalon.xml"
  var name_result=    name_prefix + ".id.result.xml"
  var name_etalon=    name_prefix + ".result.etalon.xml"
  var name_diff=      name_prefix + ".id.result.diff"

  run_test(name_test_file,format,name_result)

  var fc_result= compare_results(name_etalon,name_result,name_diff)
  print_test_res(test_prompt,fc_result)
}

function check_os_specific(format,test_name,test_prompt)
{
  var name_found=           format + "_" + test_name
  var name_test_file=       ".\\t\\" + name_found + ".test.xml"
  var name_prefix=          ".\\r\\" + name_found
  var name_interim_result=  name_prefix + ".interim.result.xml"
  var name_result=          name_prefix + ".result.xml"
  var name_etalon=          name_prefix + ".result.etalon.xml"
  var name_diff=            name_prefix + ".id.result.diff"

  env("MYX_PASSWORD_STORAGE_TYPE")="4"
  run_test(name_test_file,format,name_interim_result)  

  env("MYX_PASSWORD_STORAGE_TYPE")="2"
  run_test(name_interim_result,format,name_result)

  var fc_result= compare_results(name_etalon,name_result,name_diff)
  print_test_res(test_prompt,fc_result)
  if (fc_result==0)
    fso.GetFile ( name_interim_result ).Delete()
}


print_title("test xml storing of user connections")
copy_dlls()

check             ( "charsets",   "simple", "charsets  simple read write"             )
check_idempotency ( "charsets",   "simple", "charsets  simple read write idempotency" )

check             ( "datatypes",  "simple", "datatypes simple read write"             )
check_idempotency ( "datatypes",  "simple", "datatypes simple read write idempotency" )

check             ( "options",    "simple", "options   simple read write"             )
check_idempotency ( "options",    "simple", "options   simple read write idempotency" )

env("my_cnf_path")=""
env("MYX_PASSWORD_STORAGE_TYPE")="1"
check             ("connections", "simple", "connections read write             MYX_PASSWORD_NOT_STORED (simple)")
check_idempotency ("connections", "simple", "connections read write idempotency MYX_PASSWORD_NOT_STORED (simple)")

env("MYX_PASSWORD_STORAGE_TYPE")="2"
check             ("connections", "plain",  "connections read write             MYX_PASSWORD_PLAINTEXT")
check_idempotency ("connections", "plain",  "connections read write idempotency MYX_PASSWORD_PLAINTEXT")

env("MYX_PASSWORD_STORAGE_TYPE")="3"
check             ("connections", "obscured", "connections read write             MYX_PASSWORD_OBSCURED")
check_idempotency ("connections", "obscured", "connections read write idempotency MYX_PASSWORD_OBSCURED")

check_os_specific ("connections", "os_specific", "connections read write             MYX_PASSWORD_OS_SPECIFIC")

env("MYX_PASSWORD_STORAGE_TYPE")="2"
check("connections", "obscured_to_plane", "connections read from obscured write to plane")

clear_dlls()
print_footer()

