// test_mysql_api.cpp : Defines the entry point for the console application.
//

#include "stdio.h"
#include "stdlib.h"
#include "myx_public_interface.h"

const char * filename_in= "in.xml";

///////////////////////////////////////////////////////////////////////////////
const char * get_current_database(MYSQL * mysql)
{
  char *value= NULL;
  MYSQL_RES *res;
  MYSQL_ROW row;

  if (!(myx_mysql_query(mysql, "select database()")))
  {
    if ((res= mysql_store_result(mysql)))
    {
      if ((row= mysql_fetch_row(res)))
      {
        value= g_strdup(row[0]);
      }
      mysql_free_result(res);
    }
  }

  return value;
}

///////////////////////////////////////////////////////////////////////////////
void print_errors(MYSQL * mysql)
{
  printf("myx_mysql_errno(mysql)=%d\n",myx_mysql_errno(mysql));
  printf("myx_mysql_error(mysql)=\"%s\"\n",myx_mysql_error(mysql));
}

///////////////////////////////////////////////////////////////////////////////
void test_use_schema(MYSQL * mysql)
{
  printf("|--------- test use schema ---\n");

  const char *db= get_current_database(mysql);
  printf("current database is \"%s\"\n",db);
  g_free((gpointer)db);

  int res;

  printf("myx_use_schema(mysql,\"mysql\")=%d;\n",
         (res= myx_use_schema(mysql,"mysql")));
  if (res)
    print_errors(mysql);

  db= get_current_database(mysql);
  printf("current database is \"%s\"\n",db);
  g_free((gpointer)db);

  printf("myx_use_schema(mysql,\"test\" )=%d;\n",
         (res= myx_use_schema(mysql,"test")));
  if (res)
    print_errors(mysql);

  db= get_current_database(mysql);
  printf("current database is \"%s\"\n",db);
  g_free((gpointer)db);
}

///////////////////////////////////////////////////////////////////////////////
void test_query(MYSQL * mysql)
{
  printf("|--------- test query ---\n");

  const char *db= get_current_database(mysql);
  printf("current database is \"%s\"\n",db);
  g_free((gpointer)db);

  int res;
  printf("myx_mysql_query(mysql,\"use mysql\")=%d;\n",
         (res= myx_mysql_query(mysql,"use mysql")));
  if (res)
    print_errors(mysql);

  db= get_current_database(mysql);
  printf("current database is \"%s\"\n",db);
  g_free((gpointer)db);

  printf("myx_mysql_real_query(mysql,\"use test\",8)=%d;\n",
         (res= myx_mysql_real_query(mysql,"use test",8)));
  if (res)
    print_errors(mysql);

  db= get_current_database(mysql);
  printf("current database is \"%s\"\n",db);
  g_free((gpointer)db);

  printf("myx_mysql_query(mysql,\"use non_existent_database\")=%d\n",
         (res= (myx_mysql_query(mysql,"use non_existent_database")?1:0)));
  if (res)
    print_errors(mysql);

  db= get_current_database(mysql);
  printf("current database is \"%s\"\n",db);
  g_free((gpointer)db);
}

///////////////////////////////////////////////////////////////////////////////
void test_charsets(MYSQL * mysql)
{
  printf("|--------- test charsets ---\n");

  char *txt;

  printf("myx_convert_dbstr_utf8(mysql,\"mysql\")=\"%s\";\n",
         (txt= myx_convert_dbstr_utf8(mysql,"mysql")));
  fflush(stdout);
  g_free(txt);

  printf("myx_convert_dbstr_utf8(mysql,\"test\")=\"%s\";\n",
         (txt= myx_convert_dbstr_utf8(mysql,"test")));
  fflush(stdout);
  g_free(txt);

  printf("myx_convert_utf8_dbstr(mysql,\"mysql\")=\"%s\";\n",
         (txt= myx_convert_utf8_dbstr(mysql,"mysql")));
  fflush(stdout);
  g_free(txt);

  printf("myx_convert_utf8_dbstr(mysql,\"test\")=\"%s\";\n",
         (txt= myx_convert_utf8_dbstr(mysql,"test")));
  fflush(stdout);
  g_free(txt);
}

void test_catalogs(MYSQL * mysql);

///////////////////////////////////////////////////////////////////////////////
void test_connected_mysql(MYX_USER_CONNECTION * user_conn, MYSQL * mysql)
{
  printf("myx_get_mysql_major_version(mysql)=%d\n",
         myx_get_mysql_major_version(mysql));
  printf("myx_get_mysql_minor_version(mysql)=%d\n",
         myx_get_mysql_minor_version(mysql));

  printf("myx_get_server_variable(mysql,\"interactive_timeout\")=\"%s\"\n",
         myx_get_server_variable(mysql,"interactive_timeout"));

  test_charsets(mysql);
  test_use_schema(mysql);
  test_query(mysql);
  test_catalogs(mysql);
}

///////////////////////////////////////////////////////////////////////////////
void print_machine_info(MYX_MACHINE_INFO * machine_info)
{
  /*printf("machine_info->version=\"%s\"\n",
         !machine_info->version?"":machine_info->version);
  printf("machine_info->network_name=\"%s\"\n",
         !machine_info->network_name?"":machine_info->network_name);
  printf("machine_info->IP=\"%s\"\n",
         !machine_info->IP?"":machine_info->IP);
  printf("machine_info->OS=\"%s\"\n",
         !machine_info->OS?"":machine_info->OS);
  printf("machine_info->hardware=\"%s\"\n",
         !machine_info->hardware?"":machine_info->hardware);

  
  printf("myx_is_localhost(machine_info->network_name)=%d\n",
          myx_is_localhost(machine_info->network_name));
  unsigned long ip= myx_resolve_network_name(machine_info->network_name);
  printf("myx_resolve_network_name(machine_info->network_name)=%u\n",
         (unsigned int)ip);

  MYX_PING_RESULT ping_result;
  printf("myx_ping_host(%u,10,&ping_result)=%d\n",
         (unsigned int)ip,myx_ping_host(ip,10,&ping_result));
  printf("ping_result.round_trip_time=%d\n",ping_result.round_trip_time);
  printf("ping_result.ttl=%d\n",ping_result.ttl);*/
}

///////////////////////////////////////////////////////////////////////////////
void test_pc_info(MYX_USER_CONNECTION * user_conn, MYSQL * mysql)
{
  printf("|--------- test pc info ---\n");
  MYX_MACHINE_INFO * machine_info;

  printf("|--{ machine_info= myx_get_server_info(user_conn,mysql):\n");
  machine_info= myx_get_server_info(user_conn,mysql);
  print_machine_info(machine_info);
  printf("|--} myx_free_pc_info(machine_info);\n");
  myx_free_pc_info(machine_info);

  printf("|--{ machine_info= myx_get_client_info(mysql):\n");
  machine_info= myx_get_client_info(mysql);
  print_machine_info(machine_info);
  printf("|--} myx_free_pc_info(machine_info);\n");
  myx_free_pc_info(machine_info);
}

///////////////////////////////////////////////////////////////////////////////
void test_mysql(MYX_USER_CONNECTION * user_conn, MYSQL * mysql)
{
  if (!myx_connect_to_instance(user_conn,mysql))
  {
    printf("connection have been established (myx_connect_to_instance)\n");
    test_connected_mysql(user_conn,mysql);
    test_pc_info(user_conn,mysql);
  }
}

///////////////////////////////////////////////////////////////////////////////
const char * get_fname(const char *path)
{
  if (!path)
    return path;
  const char * res= path;
  for ( ;*path!=0; path++)
  {
    if (*path=='\\' || *path=='/')
      res= path+1;
  }
  return res;
}

///////////////////////////////////////////////////////////////////////////////
void test_connection(MYX_USER_CONNECTION * user_conn)
{
  printf("myx_get_my_cnf_path()=\"%s\"\n",get_fname(myx_get_my_cnf_path()));

  char * var;
  if ((var= getenv("my_cnf_path")))
  {
    printf("myx_set_my_cnf_path(\"%s\")\n",get_fname(var));
    myx_set_my_cnf_path(var);
    printf("myx_get_my_cnf_path()=\"%s\"\n",get_fname(myx_get_my_cnf_path()));
  }

  MYSQL * mysql= myx_mysql_init();
  if (mysql)
  {
    printf("MYSQL handler have been created (myx_mysql_init())\n");
    test_mysql(user_conn,mysql);
    myx_mysql_close(mysql);
  }
}

///////////////////////////////////////////////////////////////////////////////
int main()
{
  MYX_LIB_ERROR err;

  printf("myx_get_public_interface_version()=%d\n",
         myx_get_public_interface_version());

  MYX_USER_CONNECTIONS * connections=
                                   myx_load_user_connections(filename_in,&err);
  if (connections)
  {
    printf("connections have been read (myx_load_user_connections())\n");
    if (connections->user_connections_num)
      test_connection(connections->user_connections);
    myx_free_user_connections(connections);
  }

	return 0;
}

///////////////////////////////////////////////////////////////////////////////
