
#include "stdio.h"
#include "stdlib.h"
#include "myx_public_interface.h"

///////////////////////////////////////////////////////////////////////////////
void print_schema_table_columns(unsigned int columns_num,
                                MYX_SCHEMA_TABLE_COLUMN *columns)
{
  MYX_SCHEMA_TABLE_COLUMN * column= columns;
  MYX_SCHEMA_TABLE_COLUMN * end_columns= column + columns_num;
  for (; column!=end_columns; column++)
  {
    printf("              column:\n");
    printf("                column_name=\"%s\"\n",column->column_name);
    printf("                column_type=\"%s\"\n",column->column_type);
    printf("                default_value=\"%s\"\n",column->default_value);
    printf("                extra=\"%s\"\n",column->extra);
    printf("                primary_key=%u\n",column->primary_key);
    printf("                not_null=%u\n",column->not_null);
  }
}

///////////////////////////////////////////////////////////////////////////////
void print_schema_tables(MYX_SCHEMA_TABLES *schema_tables)
{
  MYX_SCHEMA_TABLE * schema_table= schema_tables->schema_tables;
  MYX_SCHEMA_TABLE * end_schema_tables=
                               schema_table + schema_tables->schema_tables_num;
  printf("        schema_tables:\n");
  printf("          schema_tables_num=%u\n",schema_tables->schema_tables_num);
  for (; schema_table!=end_schema_tables; schema_table++)
  {
    printf("            schema_table:\n");
    printf("              table_name=\"%s\"\n",schema_table->table_name);
    printf("              columns_num=%u\n",schema_table->columns_num);
    print_schema_table_columns(schema_table->columns_num,
                               schema_table->columns);
  }
}

///////////////////////////////////////////////////////////////////////////////
void print_schema_indices(MYX_SCHEMA_INDICES *schema_indices)
{
  MYX_TABLE_INDEX * index= schema_indices->indices;
  MYX_TABLE_INDEX * end_indices= index + schema_indices->indices_num;
  printf("        schema_indices:\n");
  printf("          indices_num=%u\n",schema_indices->indices_num);
  for (; index!=end_indices; index++)
  {
    MYX_TABLE_INDEX_COLUMN * index_column= index->index_columns;
    MYX_TABLE_INDEX_COLUMN * end_index_columns=
                                       index_column + index->index_columns_num;
    printf("          index:\n");
    printf("            key_name=\"%s\"\n",index->key_name);
    printf("            table_name=\"%s\"\n",index->table_name);
    printf("            index_type=\"%s\"\n",index->index_type);
    printf("            not_null=%u\n",index->not_null);
    printf("            unique=%u\n",index->unique);
    printf("            index_columns_num=%u\n",index->index_columns_num);
    for (; index_column!=end_index_columns; index_column++)
    {
      printf("            index_column:\n");
      printf("              column_name=\"%s\"\n",index_column->column_name);
      printf("              seq_in_index=\"%s\"\n",index_column->seq_in_index);
      printf("              collation=\"%s\"\n",index_column->collation);
    }
  }
}


///////////////////////////////////////////////////////////////////////////////
void print_catalogs(MYX_CATALOGS * catalogs)
{
  MYX_CATALOG * catalog= catalogs->catalogs;
  MYX_CATALOG * catalogs_end= catalog + catalogs->catalogs_num;

  printf("catalogs : \n");
  printf("  catalogs_num=%u\n",catalogs->catalogs_num);
  for (; catalog!=catalogs_end; catalog++)
  {
    MYX_SCHEMA *schemata= catalog->schemata;
    MYX_SCHEMA *schematas_end= schemata + catalog->schemata_num;
    printf("    catalog_name=\"%s\"\n",catalog->catalog_name);
    printf("      schemata_num=%u\n",catalog->schemata_num);
    for (; schemata!=schematas_end; schemata++)
    {
      printf("        schema_name=\"%s\"\n",schemata->schema_name);
      printf("        catalog_name=\"%s\"\n",schemata->catalog_name);
      if (schemata->schema_tables)
        print_schema_tables(schemata->schema_tables);
      else
        printf("        schema_tables=0\n");
      if (schemata->schema_indices)
        print_schema_indices(schemata->schema_indices);
      else
        printf("        schema_indices=0\n");
    }
  }
}

///////////////////////////////////////////////////////////////////////////////
void test_get_catalogs(MYSQL * mysql)
{
  printf("|--------- test_get_catalogs -------------\n");
  MYX_CATALOGS * catalogs= myx_get_catalogs(mysql);
  print_catalogs(catalogs);
  myx_free_catalogs(catalogs);
}

///////////////////////////////////////////////////////////////////////////////
void test_get_schema_tables(MYSQL * mysql)
{
  printf("|--------- test_get_schema_tables -------------\n");
  MYX_SCHEMA_TABLES *schema_tables= myx_get_schema_tables(mysql,"def","test");
  print_schema_tables(schema_tables);
  myx_free_schema_tables(schema_tables);
}

///////////////////////////////////////////////////////////////////////////////
void test_get_schema_indices(MYSQL * mysql)
{
  printf("|--------- test_get_schema_indices -------------\n");
  MYX_SCHEMA_INDICES *schema_indices= myx_get_schema_indices(mysql,
                                                             "def","test");
  print_schema_indices(schema_indices);
  myx_free_schema_indices(schema_indices);
}

///////////////////////////////////////////////////////////////////////////////
void print_schema_table_status(MYX_SCHEMA_TABLE_STATUS *schema_table_status)
{
  MYX_TABLE_STATUS * table_status= schema_table_status->schema_tables;
  MYX_TABLE_STATUS * end_table_statuses=
                         table_status + schema_table_status->schema_tables_num;
  printf("schema_table_status : \n");
  for (; table_status!=end_table_statuses; table_status++)
  {
    printf("  table_status : \n");
    printf("    table_name=\"%s\"\n",table_status->table_name);
    printf("    table_type=\"%s\"\n",table_status->table_type);
    printf("    row_format=\"%s\"\n",table_status->row_format);
    printf("    rows=\"%s\"\n",table_status->rows);
    printf("    avg_row_length=\"%s\"\n",table_status->avg_row_length);
    printf("    data_length=\"%s\"\n",table_status->data_length);
    printf("    max_data_length=\"%s\"\n",table_status->max_data_length);
    printf("    index_length=\"%s\"\n",table_status->index_length);
    printf("    data_free=\"%s\"\n",table_status->data_free);
    printf("    auto_increment=\"%s\"\n",table_status->auto_increment);
    printf("    create_time=\"%s\"\n","x"/*table_status->create_time*/);
    printf("    update_time=\"%s\"\n","x"/*table_status->update_time*/);
    printf("    check_time=\"%s\"\n",table_status->check_time);
    printf("    create_options=\"%s\"\n",table_status->create_options);
    printf("    comment=\"%s\"\n",table_status->comment);
    printf("    indexes:\n");
    MYX_SCHEMA_INDICES indices= {table_status->indexes_num,
                                 table_status->indexes};
    print_schema_indices(&indices);
    printf("    columns:\n");
    print_schema_table_columns(table_status->columns_num,
                               table_status->columns);
  }
}

///////////////////////////////////////////////////////////////////////////////
void test_get_schema_table_status(MYSQL * mysql)
{
  printf("|--------- test_get_schema_table_status -------------\n");
  MYX_SCHEMA_TABLE_STATUS *schema_table_status=
                               myx_get_schema_table_status(mysql,"def","test");
  print_schema_table_status(schema_table_status);
  myx_free_schema_table_status(schema_table_status);
}

///////////////////////////////////////////////////////////////////////////////
void fill_test_schema(MYSQL * mysql)
{
  myx_mysql_query(mysql, "use test");
  myx_mysql_query(mysql, "create table t1 (a int)");
  /*myx_mysql_query(mysql,
                "create table t2 (enum_with_russian_symbols enum('',''))");*/
  myx_mysql_query(mysql, "create table t3 (a1 int, a2 int, a3 int, a4 int,"
                                  "index(a1), index(a1,a2), index(a4,a3))");
}

///////////////////////////////////////////////////////////////////////////////
void free_test_schema(MYSQL * mysql)
{
  myx_mysql_query(mysql,"drop table t1, t2, t3");
}

///////////////////////////////////////////////////////////////////////////////
void test_catalogs(MYSQL * mysql)
{
  fill_test_schema              (mysql);
  test_get_catalogs             (mysql);
  test_get_schema_tables        (mysql);
  test_get_schema_indices       (mysql);
  test_get_schema_table_status  (mysql);
  free_test_schema              (mysql);
}

