// osx_dac.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifdef MACOSX

// Converter subclass for Mac OSX.

#ifndef OSX_DAC_H
#ifdef __GNUG__
#pragma interface
#endif
#define OSX_DAC_H

#include "converter.h"
#include <CoreAudio/CoreAudio.h>

class MyTimer;

class OSXConverter : public RealConverter {
	typedef RealConverter Super;
	friend MyTimer;
public:
	OSXConverter();
	virtual ~OSXConverter();
	redefined int pause();
	redefined int resume();
	redefined int stop();
	redefined int currentPlayLevel() const;
	redefined int currentRecordLevel() const;
	redefined boolean setPlayLevel(int);
	redefined boolean setRecordLevel(int);
	redefined boolean setSpeakerOutput(boolean);
protected:
	redefined DataType bestPlayableType() { return FloatData; }
	redefined boolean isPlayableFormat(DataType type);
	redefined int doConfigure();
	redefined int doConversion(ProgressAction *);
	redefined int doRecording(ProgressAction *);
	redefined int checkSampleRate(int rate);
	redefined int checkChannels(int chans);
	redefined int checkDataType(DataType type);
	class OSXConfigRequester : public RealConverter::ConfigRequester {
	public:
		OSXConfigRequester(RealConverter* cvtr) : ConfigRequester(cvtr) {}
	protected:
		redefined void configureRequest(Request *);
		redefined boolean confirmValues();
	};
	friend boolean OSXConfigRequester::confirmValues();
	redefined Requester* configRequester() {
		return new OSXConfigRequester(this);
	}
	friend class Controller;
private:
	AudioDeviceID				_recDeviceID;
	AudioDeviceID				_playDeviceID;
	AudioStreamBasicDescription _deviceFormat;
	unsigned int 				_audioBufferSize;
	unsigned int				_bytesToDo;
	unsigned int				_bytesDone;
	MyTimer						*_timer;
private:
	static OSStatus audioRecordProc(AudioDeviceID           inDevice,
									const AudioTimeStamp    *inNow,
									const AudioBufferList   *inInputData,
									const AudioTimeStamp    *inInputTime,
									AudioBufferList         *outOutputData,
									const AudioTimeStamp    *inOutputTime,
									void                    *object);
	static OSStatus audioPlayProc(AudioDeviceID           inDevice,
								const AudioTimeStamp    *inNow,
    							const AudioBufferList   *inInputData,
    	  						const AudioTimeStamp    *inInputTime,
    	  						AudioBufferList         *outOutputData,
    	  						const AudioTimeStamp    *inOutputTime,
    	  						void                    *object);
};

#endif

#endif	/* MACOSX */
