// menus.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Specialized subclasses of InterViews Menu and MenuItem classes for use in
// MXV.  The Enable() method greys out the displayed text.  Each Command
// instance contains an Action instance (see InterViews/action.h) which 
// encapsulates the method called by the selection of the menu item.

#ifndef MENUS_H
#ifdef __GNUG__
#pragma interface
#endif
#define MENUS_H

#include <InterViews/menu.h>

class Action;
class VMessage;
class CommandState;

class PulldownCommandMenu : public PulldownMenu {
public:
	PulldownCommandMenu(const char* str, boolean enabled=true);
	virtual ~PulldownCommandMenu() {}
	redefined void Enable(boolean);
private:
	VMessage* cmdLabel;
};

class PullrightCommandMenu : public PullrightMenu {
public:
	PullrightCommandMenu(const char* str, boolean enabled=true);
	virtual ~PullrightCommandMenu() {}
	redefined void Enable(boolean);
private:
	VMessage* cmdLabel;
	VMessage* arrowLabel;
};

class Command : public MenuItem {
public:
	Command(const char* str,
			const char* keystr,
			unsigned activeFlags,
			Action* action,
			CommandState *state);
	virtual ~Command();
	redefined void Update();
	redefined void Do();
	redefined void Enable(boolean);
private:
	unsigned		_activeFlags;
	Action			*_action;
	CommandState	*_cmdState;
	VMessage 		*_cmdMessage;
	VMessage 		*_keyMessage;
};

struct MenuInfo {
	const char* str;
	const char* keystr;
	unsigned long code;
	unsigned activeFlags;
	struct MenuInfo* submenuInfo;
};

struct MenuBarInfo {
	char *title;
	MenuInfo *info;
};

#endif

