// channelview.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// A ChannelView object controls the visual display of a Data object when it is
// being displayed as a set of graphs representing the information in each
// channel.  It contains a minimum of one ChannelGraph object.  The DataView
// base class implements the Graph subclass coordination.

#ifndef CHANNELVIEW_H
#ifdef __GNUG__
#pragma interface
#endif
#define CHANNELVIEW_H

#include "dataview.h"

class HScale;
class VBox;
class Panner;
class Event;
class Perspective;
class Data;
class Range;
class Controller;
class ChannelGraph;
class EditStatusDelegate;

class ChannelView : public DataView {
	typedef DataView Super;
public:
	ChannelView(Controller *, ViewInfo &);
	virtual ~ChannelView();

	// methods invoked by menu items

	redefined void setChannelRange();
	redefined void shiftChannelViewUp();
	redefined void shiftChannelViewDown();
	redefined void toggleGraphMode();

	// redefined to avoid hiding

	redefined void setVisibleFrameRange() { DataView::setVisibleFrameRange(); }
	redefined void setInsertPoint() { DataView::setInsertPoint(); }
	redefined void setEditRegion() { DataView::setEditRegion(); }
	redefined void setInsertPoint(int, const Range&, boolean scroll=true);
	redefined void setEditRegion(const Range&, const Range&, boolean scroll=true);
	redefined Range getHorizScaleRange();
	redefined Range getVisibleFrameRange();
	redefined void resetHorizontalScale();
	redefined void setVisibleFrameRange(const Range &);
	redefined Range getChannelRange();
	redefined void setChannelRange(const Range &);
	redefined boolean keyCommand(unsigned long cmd);
	redefined boolean frameScaleInFrames() { return horizScaleInFrames(); }

	// methods new to this subclass
	virtual void addChannel();
	virtual void removeChannel();
	void setScaleOptions();
protected:
	redefined int graphsVisible();
	redefined void addGraph(Graph *);
	
	// methods new to this subclass
	void addChannel(int chan);
	void addChannel(int chan, Range &);
private:
	friend class Controller;
	friend class EditStatusDelegate;

	void Init(ViewInfo &);
	redefined const char* plotWidthAttribute() { return "ChannelPlotSize"; }
	redefined void initPerspective();
	redefined void checkPerspective();
	redefined void constrainVerticalView(Perspective &);
	redefined void incrementGraphsVisible();
	redefined void decrementGraphsVisible();
	int lowestChannel();
	void setLowestChannel(int chan);
	int highestChannel();
	int nchans();
	void setNChans(int chans);
	int maxChans();
	
	Perspective *channelsShown;
};

#endif
