// block.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Subclasses of Block are used to iterate through a list of Interactor
// subclasses (such as ChannelGraphs) to call an identical method on all
// elements in the list.

#ifndef BLOCK_H
#define BLOCK_H

#include "localdefs.h"
#include "range.h"

class Interactor;

class Block {
protected:
    boolean done;
public:
    virtual ~Block() {}
    virtual void doIt(Interactor *)=0;
    boolean doAndDone(Interactor *i) {
		done = false;
		if (i != nil)
		    doIt(i);
		else
			done = true;
		return done;
    }
};

// execute command if object matches target or target is nil

class TargetBlock : public Block {
	Interactor *target;
public:
	TargetBlock(Interactor *i) : target(i) {}
	redefined void doIt(Interactor *i) {
		if(target == nil || target == i)
			doThis(i);
	}
	virtual void doThis(Interactor *i) = 0;
};

// execute command for all objects except thisOne

class DoExceptBlock : public Block {
	Interactor *thisOne;
public:
	DoExceptBlock(Interactor *notThis) : thisOne(notThis) {}
	redefined void doIt(Interactor *i) {
		if(i != thisOne)
			doThis(i);
	}
	virtual void doThis(Interactor *i) = 0;
};

#endif

