/*
 * mxallowd
 * (c) 2007-2008 Michael Stapelberg
 * 
 * See mxallowd.c for description, website and license information
 *
 */

#include <stdbool.h>

#ifndef _WHITELIST_INCLUDED
#define _WHITELIST_INCLUDED
struct whitelist_entry {
	char *ip_address;
	char *rdns;
	/* 
	 * is_child will be set to true if this entry is one of the IP-addresses obtained
	 * by looking up the RDNS
	 *
	 */
	bool is_child;
	/*
	 * used is the indicator for statistics. It will be set to true if this entry was
	 * used for allowing the connection to a mailserver
	 *
	 */
	bool used;
	/*
	 * rdns_tried is set to 1 as soon as the resolver-thread tried to resolve the rdns.
	 * This is needed because rdns can stay NULL if there is no hostname or if the
	 * resolving fails
	 *
	 */
	bool rdns_tried;
	time_t added;
	struct whitelist_entry *next;
};

bool is_whitelisted(char*, bool);
void cleanup_whitelist();
void add_to_whitelist(char*, char*, bool, int, const void *);

#ifdef _WHITELIST_INTERNAL
struct whitelist_entry *root = NULL;
#else
extern struct whitelist_entry *root;
#endif
#endif
