/*
 *   mwmstar.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include "mwmparse.h"
#include "mwmparsi.h"


/*****************************************************************************/
/* Routine to determine which Class 2 fax command has been issued.           */
/*****************************************************************************/
USHORT mwmStarCommand(STATEINFO *psi)
{

  USHORT  usParserStatus = 0;
  USHORT  usCommandLength = 0;
  USHORT  usParm;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmstar::mwmStarCommand entry\n");


  /***************************************************************************/
  /* Look at this character in AT Command.                                   */
  /* Then advance index to point to next character.                          */
  /***************************************************************************/
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"TH",strlen("TH")))
  {
    /*************************************************************************/
    /* This is a *TH command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("TH");
    psi->usNextATIndex += usCommandLength;

    if ( (psi->usNextPPIndex + PP_STAR_TH_CMD_SPACE) < PP_BUFFER_THRESHOLD) 
    {                                                           

      /*********************************************************************/
      /* Step over =                                                       */
      /*********************************************************************/
      if (psi->achCommandBuffer[psi->usNextATIndex] == '=')
        psi->usNextATIndex++;

      /*********************************************************************/
      /* Get the parameter from the command string                         */
      /*********************************************************************/
      usParm = mwmParseGetArgFromATString(psi->achCommandBuffer, 
                                     &psi->usNextATIndex);       
                                                                 
      usParserStatus = mwmStarTHCommand(psi,usParm);             
                                                                 
    }                                                            
    else                                                         
    {                                                            
      /*********************************************************************/
      /* There is not enough room left in this PP Command buffer to        */
      /* process this command....                                          */
      /*********************************************************************/
      usParserStatus = MWM_GET_MORE_BUFFERS;                      
      psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;              
    }                                                              
  }
  else
    usParserStatus = MWM_ATCMD_ERROR;





  /***************************************************************************/
  /* If this command was valid (accepted by the parser)                      */
  /***************************************************************************/
  if (!usParserStatus)
  {
    /*************************************************************************/
    /* If we are pointing at whitespace or a semicolon,                      */
    /* move the pointer forward until we are past the whitespace and         */
    /* semicolons.                                                           */
    /*************************************************************************/
    while ((psi->achCommandBuffer[psi->usNextATIndex] == ' ') ||
           (psi->achCommandBuffer[psi->usNextATIndex] == ';'))
      psi->usNextATIndex++;
  }



  if (usParserStatus & MWM_GET_MORE_BUFFERS)
    /*************************************************************************/
    /* Move the AT Command Index back to this command to be parsed           */
    /* on the next interrupt.                                                */
    /*************************************************************************/
    psi->usNextATIndex-= usCommandLength;

 MW_SYSLOG_2(TRACE_MWMPW32,"mwmstar::mwmStarCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}


USHORT  mwmStarTHCommand(STATEINFO *psi, USHORT usParm)
{
  USHORT usParserStatus = 0;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmstar::mwmStarTHCommand entry\n");
  switch (usParm)
  {
    case 0:
    case 3:
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x2f | psi->usParserMode;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      break;
    case 1:
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x2f | psi->usParserMode;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      break;
    case 2:
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x2f | psi->usParserMode;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      break;
    case 4:
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x2f | psi->usParserMode;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      break;
    case 5:
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x2f | psi->usParserMode;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      break;
    case 6:
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x2f | psi->usParserMode;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      break;
    case 7:
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x2f | psi->usParserMode;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      break;
    case 8:
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x2f | psi->usParserMode;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      break;
    default:
      usParserStatus = MWM_ATCMD_ERROR;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmstar::mwmStarTHCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}



