/*
 *   blwtt.c
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                         
 *   blwtt.h
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
//  This class loads blacklist settings from the WT Table and makes them
//  available to the other blacklist objects.  Because the purpose is to
//  pass information, all variables are public.
//
//
//
//
//****************************************************************************
#include <blwtt.h>       // This class header file
#include <unsucces.h>    // For MAX_TIME_STAMP_COUNT
#include <mwwttbl.h>     // Header file
#include <wtt.h>         // Field and parameter definitions for the WTT
#include <stdio.h>       // for debug stuff
#include <string.h>      // for debug stuff

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
//  Reset
//
//     This function is used to reset (reload) the WTTsetting variables.
//
//
//     Params:   none
//
//     Returns:  ULONG Successful:  0
//                     Error:       BLERR_.... from mwblapi.h
//
//-------------------------------------------------------------------------
ULONG wttReset (WTTsettings *pWTT)
{
  ULONG ulError;
  short  sParameter;
  
  // Specify that it is not loaded
  pWTT->bWTTloaded=FALSE;

  ulError=WTT_GetCurrentCountry (NULL, &(pWTT->ulCountryNumber), 0L);
  if (ulError) {
    MW_SYSLOG_2(TRACE_MWMBL,"blwtt::wttReset, ERROR call to WTT_GetCurrentCountry returned with ulError %lx\n" , ulError);
    return BLERR_WTT_READ_FAILED;
  }

  // Set bBlacklistingEnabled, usUnsuccessfulRetryDelay, and usMaxUnsuccessfulCount
  ulError=WTT_QueryInfo (NULL, WTBLOCK_BLACKLIST, WTPARAM_FSUC, WTLENGTH_ONEPARAM, &sParameter, 0L);
  if (ulError) {
    MW_SYSLOG_2(TRACE_MWMBL,"blwtt::wttReset, ERROR call to WTT_QueryInfo returned with ulError %lx\n", ulError);
    return BLERR_WTT_READ_FAILED;
  }
  
  MW_SYSLOG_2(TRACE_MWMBL,"blwtt::wttReset, blacklist value %x from WTT_QueryInfo\n",sParameter);
  pWTT->bBlacklistingEnabled = sParameter;  // if there is anything defined in this word, then
                                      // blacklisting is suppose to be enabled.  If this
                                      // word is zero, blacklisting could still be enabled
                                      // further down if special code for the country is
                                      // to be used.

  pWTT->ulUnsuccessfulRetryDelay = (ULONG) (sParameter & FSUC_DELAY);

  pWTT->ulMaxUnsuccessfulCount   = (ULONG) ((sParameter & FSUC_COUNT) >> 8);

  pWTT->bBlacklistAfterFirstSeries = (BOOL) (sParameter & FSUC_INHIBIT);

  // Get the control bits
  ulError=WTT_QueryInfo(NULL, WTBLOCK_BLACKLIST, WTPARAM_BLCTRL, WTLENGTH_ONEPARAM, &sParameter, 0L);
  if (ulError) {
    MW_SYSLOG_2(TRACE_MWMBL,"blwtt:wttReset, ERROR call to WTT_QueryInfo returned with ulError %lx\n",ulError);
    return BLERR_WTT_READ_FAILED;
  }

  MW_SYSLOG_2(TRACE_MWMBL,"blwtt::wttReset, blacklist special value %x from WTT_QueryInfo\n",sParameter);
  pWTT->bUseSpecialAlgorithm  = (BOOL) (sParameter & USE_SPECIAL_ALGORITHM);
  if (pWTT->bUseSpecialAlgorithm)
    pWTT->bBlacklistingEnabled = TRUE;  // enable blacklisting

  pWTT->bUseTimeWindowing            = (BOOL) (sParameter & USE_TWINDOW);

  pWTT->bUserAbortIsUnsuccessful     = (BOOL) (sParameter & ABORT_IS_UNSUCCESSFUL);

  pWTT->bDoNotDistiguishPhoneNumbers = (BOOL) (sParameter & GROUP_ALL_NUMBERS);

  // Get the second series stuff
  ulError=WTT_QueryInfo (NULL, WTBLOCK_BLACKLIST, WTPARAM_SSUC, WTLENGTH_ONEPARAM, &sParameter, 0L);
  if (ulError) {
    MW_SYSLOG_2(TRACE_MWMBL,"blwtt::wttReset, ERROR call to WTT_QueryInfo returned ulError %lx\n", ulError);
    return BLERR_WTT_READ_FAILED;
  }
  
  MW_SYSLOG_2(TRACE_MWMBL,"blwtt::wttReset, blacklist SSUC value %x from WTT_QueryInfo\n",sParameter);
  // In this version, force the first and second series to be the same.
  if ( ! pWTT->bBlacklistAfterFirstSeries && ! pWTT->bUseTimeWindowing) {
    if (pWTT->ulUnsuccessfulRetryDelay != (ULONG) (sParameter & SSUC_DELAY)) {
      MW_SYSLOG_1(TRACE_MWMBL,"blwtt::wttReset, ERROR with WTPARAM_SSUC retry delay different than WTPARAM_FSUC\n");
      return BLERR_WTT_READ_FAILED;
    }
    
    if (pWTT->ulMaxUnsuccessfulCount != (ULONG) ((sParameter & SSUC_COUNT) >> 8)) {
      MW_SYSLOG_1(TRACE_MWMBL,"blwtt::wttReset, ERROR with WTPARAM_SSUC retry count different than WTPARAM_FSUC\n");
      return BLERR_WTT_READ_FAILED;
    }
    
    pWTT->bBlacklistAfterSecondSeries = (BOOL) (sParameter & SSUC_INHIBIT);

    // Now let's get the series-to-series delay
    ulError=WTT_QueryInfo (NULL, WTBLOCK_BLACKLIST, WTPARAM_FSSD, WTLENGTH_ONEPARAM, &sParameter, 0L);
    if (ulError) {
      MW_SYSLOG_2(TRACE_MWMBL,"blwtt::wttReset, ERROR call to WTT_QueryInfo returned ulError %lx\n", ulError);
      return BLERR_WTT_READ_FAILED;
    }
    MW_SYSLOG_2(TRACE_MWMBL,"blwtt::wttReset, blacklist FSSD value %x from WTT_QueryInfo\n",sParameter);
    pWTT->ulSeriesToSeriesDelay = (ULONG) sParameter;
  } else {  // no second series
    pWTT->bBlacklistAfterSecondSeries = FALSE;
    pWTT->ulSeriesToSeriesDelay = 0;
  }
  
  // If time windowing was selected, we need to verify that the count will fit in the
  // defined array size.
  if (pWTT->bUseTimeWindowing) {
    if (pWTT->ulMaxUnsuccessfulCount > MAX_TIME_STAMP_COUNT) {
      MW_SYSLOG_1(TRACE_MWMBL,"blwtt::wttReset, ERROR Max unsuccessful count from WT Table set too large to handle\n");
      return BLERR_WTT_MAX_COUNT_TOO_LARGE;
    }
  }
  
  // Next the all call delay needs to get set
  ulError=WTT_QueryInfo (NULL, WTBLOCK_BLACKLIST, WTPARAM_CALLDLY, WTLENGTH_ONEPARAM, &sParameter, 0L);
  if (ulError) {
    MW_SYSLOG_2(TRACE_MWMBL,"blwtt::wttReset, ERROR call to WTT_QueryInfo returned ulError %lx \n", ulError);
    return BLERR_WTT_READ_FAILED;
  }
  MW_SYSLOG_2(TRACE_MWMBL,"blwtt::wttReset, blacklist Call Delay value %x from WTT_QueryInfo\n",sParameter);
  pWTT->ulAllCallDelay = (ULONG) sParameter;
  
  // Now we set the first retry delay
  ulError=WTT_QueryInfo (NULL, WTBLOCK_BLACKLIST, WTPARAM_FIRSTDLY, WTLENGTH_ONEPARAM, &sParameter, 0L);
  if (ulError) {
    MW_SYSLOG_2(TRACE_MWMBL,"blwtt::wttReset, ERROR call to WTT_QueryInfo returned with ulError %lx\n", ulError);
    return BLERR_WTT_READ_FAILED;
  }
  
  MW_SYSLOG_2(TRACE_MWMBL,"blwtt::wttReset, blacklist First Retry Delay value %x from WTT_QueryInfo\n",sParameter);
  // If the WT Table has a zero setting then the first delay is the same as other retry delays.
  // The first retry delay can not be greater than the rest of the delays.
  if ((sParameter == 0) || ((ULONG)sParameter > pWTT->ulUnsuccessfulRetryDelay))
    pWTT->ulFirstRetryDelay=pWTT->ulUnsuccessfulRetryDelay;
  else
    pWTT->ulFirstRetryDelay = (ULONG) sParameter;

  // Here we set the time window
  ulError=WTT_QueryInfo (NULL, WTBLOCK_BLACKLIST, WTPARAM_TWINDOW, WTLENGTH_ONEPARAM, &sParameter, 0L);
  if (ulError) {
    MW_SYSLOG_2(TRACE_MWMBL,"blwtt::wttReset, ERROR call to WTT_QueryInfo returned ulError %lx\n", ulError);
    return BLERR_WTT_READ_FAILED;
  }
  MW_SYSLOG_2(TRACE_MWMBL,"blwtt::wttReset, blacklist time window value %x from WTT_QueryInfo\n",sParameter);
  pWTT->ulTimeWindow = (ULONG) sParameter;

  // Specify that the table is loaded
  pWTT->bWTTloaded    = TRUE;

  MW_SYSLOG_3(TRACE_MWMBL,"blwtt::wttReset, pWTT %p, pWTT->bBlacklistingEnabled %x\n",pWTT,pWTT->bBlacklistingEnabled);
  return BL_SUCCESSFUL;

}

BOOL wttIsWTTloaded(WTTsettings *pWTT) {
  return pWTT->bWTTloaded;
}
