/*
 *   dspmgri.h -- DSP Manager Internal IOCTL interface to DSP Manager
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#define PDDINTFVER           0x104L     // CH14 PDD Interface version

/************ CH12 Begin **********************************************/
#define IOC1_Dspmgr           0x40L     // Pass address of PG to PDD
#define IOC1_LocateDSPs       0x41L     // Locate all BDD drivers
#define IOC1_Thread_Run       0x42L     // Unblock the current PDD thread
#define IOC1_BIOS_Reset       0x43L     // BDD DSP Reset function
#define IOC1_Abilities        0x44L     // BDD Query function
#define IOC1_MemTransfer      0x45L     // BDD DSP Memtransfer function
#define IOC1_BIOS_Run         0x46L     // BDD DSP Run function
#define IOC1_Copy_QueryBuffer 0x47L     // Copy Query buffer daemon->caller
#define IOC1_Error            0x48L     // Cleanup after daemon termination
#define IOC1_Run_IPC_Thread   0x49L     // Unblock an IPC thread
#define IOC1_SetupGlobal      0x4AL     // Map PDD/Daemon shared mem to global
#define IOC1_BLOCK            0x4BL     // Block an IPC thread for LIB
#define IOC1_Suspend          0x4CL     // BDD DSP Suspend function CH13
#define IOC1_Resume           0x4DL     // BDD DSP Resume function  CH13
// Leave space for APM_Wait_Event                                   CH15
#define IOC1_DCTransfer       0x4FL     // BDD Data cache transfer  CH15
#define IOC1_PhysToLog        0x50L     // BDD Address translation  CH15
// Leave space for APM external Suspend Request                     CH15
#define IOC1_DCBlock          0x52L     // Notification block       CH15
#define CATEGORY1             0x80L     // Functions used by Daemon
/************ CH12 End ************************************************/

  typedef struct seloff {   /**/
     USHORT _lo;
     USHORT _hi;
     } seloff;


/**************************************************************/
/* DSP Manager SYSTEM IOCTLS (internal use only!)             */
/**************************************************************/

   typedef struct rparm_dspmgr { /**/
      PVOID  DSPMGR_pg;
      } RPARM_DSPMGR;

   typedef struct rparm_block   { /**/
      PFN    BLOCK_pfnIPCNotice;
      HIPC   BLOCK_hIPC;
      ULONG  BLOCK_ulRC;                        // Error code returned
      } RPARM_BLOCK;

   typedef struct rparm_run_ipc { /**/
      HIPC   RUN_IPC_hIPC;
      ULONG  RUN_IPC_ulRC;                      // Error code returned
      } RPARM_RUN_IPC;

   typedef struct rparm_copy_querybuffer { /**/
      PVOID   CQB_pBuffer;
      USHORT  CQB_usSize;
      ULONG   CQB_ulRC;                         // Error code returned
      } RPARM_COPY_QUERYBUFFER;

/* CH13 Begin */
   typedef struct rparm_suspenddsp { /**/
         HDSP       SuspendDSP_hDsp;        /* DSP handle              */
         ULONG      SuspendDSP_ulRC;        /* Return Code             */
   } RPARM_SUSPENDDSP;

   typedef struct rparm_resumedsp {  /**/
         HDSP       ResumeDSP_hDsp;         /* DSP handle              */
         ULONG      ResumeDSP_ulRC;         /* Return Code             */
   } RPARM_RESUMEDSP;
/* CH13 End */

/* CH15 begin */
   typedef struct rparm_dcblock {  /**/
         USHORT     DCBLOCK_usEvent;        /* Insertion/Removal       */
         ULONG      DCBLOCK_ulRC;           /* Return Code             */
   } RPARM_DCBLOCK;
/* CH15 end   */
