/* dspbios.h: This file contains the prototypes for all DSP primitive       
 *          BIOS routines. These are the routines that directly interface  
 *          to the DSP.                                                    
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */

#include <mwavepub.h>

RC   FAR PASCAL DspBIOS_D_ReadClear(PRDSP prdsp, ULONG ulDspAddress, ULONG ulSize, PVOID pBuf);
RC   FAR PASCAL DspBIOS_D_Read (PRDSP prdsp, ULONG ulDspAddress, ULONG ulSize, PVOID pBuf);
RC   FAR PASCAL DspBIOS_D_Write (PRDSP prdsp, ULONG ulDspAddress, ULONG ulSize, PVOID pBuf);
RC   FAR PASCAL DspBIOS_I_Read (PRDSP prdsp, ULONG ulDspAddress, ULONG ulSize, PVOID pBuf);
RC   FAR PASCAL DspBIOS_I_Write (PRDSP prdsp, ULONG ulDspAddress, ULONG ulSize, PVOID pBuf);
RC   FAR PASCAL DspBIOS_Reset (PRDSP prdsp);
RC   FAR PASCAL DspBIOS_Resume (PRDSP prdsp);
RC   FAR PASCAL DspBIOS_Suspend (PRDSP prdsp);
RC   FAR PASCAL DspBIOS_Run (PRDSP prdsp);
VOID DspBIOS_DspOff(HANDLE hDriver);
RC     DspBIOS_Abilities (PRDSP prdsp, PUSHORT pusSize, PVOID InfoBuf);
RC     DspBIOS_WaitForIPC(HANDLE hPrivateDrv, USHORT usIpcNum);
RC     DspBIOS_CancelIPC(HANDLE hPrivateDrv, USHORT usIpcNum);
RC     PASCAL DspBIOS_RegisterIPCEvent( HANDLE hDriver, USHORT usIPCNum);
RC     PASCAL DspBIOS_GetIPCEvent( HANDLE hDriver, USHORT usIPCNum);
RC     PASCAL DspBIOS_UnregisterIPCEvent( HANDLE hDriver, USHORT usIPCNum);
RC     DspBIOS_CreatePFT( PVOID pBuffer, ULONG ulBuffSize, PUSHORT pusNumPages, PPFT pPageTable );
void * DspBIOS_AllocateDMAPages( WORD wPageCount );
void   DspBIOS_FreeDMAPages( void * pvDMABuffer );
RC     PASCAL BiosStartDMA( HANDLE hDrv,ULONG PftHandle);
RC     PASCAL BiosStopDMA( HANDLE hDrv,ULONG PftHandle);
RC     PASCAL DspBIOS_RestoreUartState( PRDSP prdsp );
RC     PASCAL DspBIOS_SaveUartState( PRDSP prdsp );
RC     DspBIOS_Dump(VOID);
