//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: sigscale.h,v 1.1.1.1 2003/10/29 10:06:31 wschweer Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __SIGSCALE_H__
#define __SIGSCALE_H__

#include "view.h"

class QPainter;
class MidiEditor;

//---------------------------------------------------------
//   SigScale
//    Time Signature Scale
//---------------------------------------------------------

class SigScale : public View {
      Q_OBJECT
      int* raster;
      int pos[3];
      int button;

   signals:
      void posChanged(int, int);

   protected:
      virtual void pdraw(QPainter&, const QRect&);
      virtual void viewMousePressEvent(QMouseEvent* event);
      virtual void viewMouseMoveEvent(QMouseEvent* event);
      virtual void viewMouseReleaseEvent(QMouseEvent* event);
      virtual void leaveEvent(QEvent*e);

   signals:
      void timeChanged(int);

   public slots:
      void setPos(int, int, bool);

   public:
      SigScale(int* raster, QWidget* parent, int xscale);
      };
#endif

