//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: citem.cpp,v 1.1.1.1 2003/10/29 10:06:28 wschweer Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#include "event.h"
#include "part.h"
#include "citem.h"
#include <stdio.h>

//---------------------------------------------------------
//   CItem
//---------------------------------------------------------

CItem::CItem()
      {
      _isMoving = false;
      }

CItem::CItem(const QPoint&p, const QRect& r)
      {
      _pos   = p;
      _bbox  = r;
      _isMoving = false;
      }

CItem::CItem(Event* e, Part* p)
      {
      _event = e;
      _part  = p;
      _isMoving = false;
      }

//---------------------------------------------------------
//   isSelected
//---------------------------------------------------------

bool CItem::isSelected() const
      {
      return _event ? _event->selected() : _part->selected();
      }

//---------------------------------------------------------
//   setSelected
//---------------------------------------------------------

void CItem::setSelected(bool f)
      {
      _event ? _event->setSelected(f) : _part->setSelected(f);
      }

//---------------------------------------------------------
//   CItemList
//---------------------------------------------------------

CItem* CItemList::find(const QPoint& pos) const
      {
      for (ciCItem i = begin(); i != end(); ++i) {
            if (i->second->contains(pos))
                  return i->second;
            }
      return 0;
      }

//---------------------------------------------------------
//   CItemList
//---------------------------------------------------------

void CItemList::add(CItem* item)
      {
      std::multimap<int, CItem*, std::less<int> >::insert(std::pair<const int, CItem*> (item->bbox().x(), item));
      }

