//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: synth.h,v 1.1.1.1 2003/10/29 10:06:05 wschweer Exp $
//
//  This file is derived from fluid Synth and modified
//    for MusE.
//  Parts of fluid are derived from Smurf Sound Font Editor.
//  Parts of Smurf Sound Font Editor are derived from
//    awesfx utilities
//  Smurf:  Copyright (C) 1999-2000 Josh Green
//  fluid:   Copyright (C) 2001 Peter Hanappe
//  MusE:   Copyright (C) 2001 Werner Schweer
//  awesfx: Copyright (C) 1996-1999 Takashi Iwai
//=========================================================

#ifndef _SYNTH_H
#define _SYNTH_H

#include <list>
#include <fluidsynth.h>
#include "mess.h"

enum SfOp { SF_REPLACE = 1, SF_ADD, SF_REMOVE };

//---------------------------------------------------------
//   ISynth
//---------------------------------------------------------

class ISynth : public Mess {
      bool _busy;
      bool _gmMode;

      fluid_synth_t* _fluidsynth;
      char* sfont;
      mutable fluid_sfont_t* fluid_font;
      mutable MidiPatch patch;

      pthread_t fontThread;

      void sysex(const unsigned char* data, int len);
      void gmOn(bool);
      void sysexSoundFont(SfOp op, const char* data);

      void allNotesOff();
      void resetAllController(int);

      virtual void write(int n, float** ports, int offset);

   protected:
      virtual void processEvent(MEvent*);

   public:
      ISynth(const char* classname);
      ~ISynth();

      fluid_synth_t* synth() { return _fluidsynth; }
      const fluid_synth_t* synth() const { return _fluidsynth; }
      char* getFont() const { return sfont; }
      void setBusy(bool val) { _busy = val; }
      //
      //   experimental MESSS interface:
      //
      virtual bool init();
      virtual const char* getPatchName(int, int, int, int, MType);
      virtual const MidiPatch* getNextPatch(int ch, const MidiPatch*) const;
      virtual bool getFirstParameter(const char*& name, const char*& value) const;
      virtual bool getNextParameter(const char*& name, const char*& value) const;
      virtual void setParameter(const char* name, const char* value);
      virtual int getMidiInitEvent(int id, RawMidiEvent*);
      };

#endif  /* _SYNTH_H */
