//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: symbols.cpp,v 1.1.1.1 2003/10/29 10:05:29 wschweer Exp $
//  (C) Copyright 1999,2000 Werner Schweer (ws@seh.de)
//=========================================================

#include <stdio.h>
#include "symbols.h"
static bool initialized = false;

static unsigned char keyBits[14][180] = {
/*0*/       {0x00,0x00,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0xc0,0x0f,
 0x00,0x00,0xc0,0x0d,0x00,0x00,0xc0,0x09,0x00,0x00,0xc0,0x08,0x00,0x00,0xc0,
 0x0c,0x00,0x00,0x40,0x0e,0x00,0x00,0x40,0x0e,0x00,0x00,0x40,0x0e,0x00,0x00,
 0xc0,0x07,0x00,0x00,0xc0,0x07,0x00,0x00,0xc0,0x03,0x00,0x00,0xe0,0x01,0x00,
 0x00,0xf0,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,0x7c,0x01,0x00,0x00,0x3c,0x01,
 0x00,0x00,0x1e,0x01,0x00,0x00,0x8f,0x1f,0x00,0x00,0xcf,0x3f,0x00,0x00,0xe7,
 0x3f,0x00,0x00,0xe7,0x7a,0x00,0x00,0x67,0x72,0x00,0x00,0x67,0x62,0x00,0x00,
 0x6f,0x62,0x00,0x00,0x4e,0x64,0x00,0x00,0x8c,0x24,0x00,0x00,0x18,0x34,0x00,
 0x00,0x70,0x1c,0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x04,
 0x00,0x00,0x00,0x08,0x00,0x00,0xe0,0x08,0x00,0x00,0xf0,0x09,0x00,0x00,0xf0,
 0x09,0x00,0x00,0xf0,0x09,0x00,0x00,0xf0,0x08,0x00,0x00,0x60,0x04,0x00,0x00,
 0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
/*1*/       { 0x00,0x00,0x03,0x06,0x00,0x80,0x07,0x09,0x00,0x80,0x07,0x07,0x00,0xc0,0x8f,
 0x04,0x00,0xc0,0x8d,0x04,0x00,0xc0,0x89,0x03,0x00,0xc0,0x08,0x00,0x00,0xc0,
 0x0c,0x00,0x00,0x40,0x0e,0x00,0x00,0x40,0x0e,0x00,0x00,0x40,0x0e,0x00,0x00,
 0xc0,0x07,0x00,0x00,0xc0,0x07,0x00,0x00,0xc0,0x03,0x00,0x00,0xe0,0x01,0x00,
 0x00,0xf0,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,0x7c,0x01,0x00,0x00,0x3c,0x01,
 0x00,0x00,0x1e,0x01,0x00,0x00,0x8f,0x1f,0x00,0x00,0xcf,0x3f,0x00,0x00,0xe7,
 0x3f,0x00,0x00,0xe7,0x7a,0x00,0x00,0x67,0x72,0x00,0x00,0x67,0x62,0x00,0x00,
 0x6f,0x62,0x00,0x00,0x4e,0x64,0x00,0x00,0x8c,0x24,0x00,0x00,0x18,0x34,0x00,
 0x00,0x70,0x1c,0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x04,
 0x00,0x00,0x00,0x08,0x00,0x00,0xe0,0x08,0x00,0x00,0xf0,0x09,0x00,0x00,0xf0,
 0x09,0x00,0x00,0xf0,0x09,0x00,0x00,0xf0,0x08,0x00,0x00,0x60,0x04,0x00,0x00,
 0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
/*2*/       { 0x00,0x00,0x03,0x79,0x00,0x80,0x87,0x09,0x00,0x80,0x87,0x1c,0x00,0xc0,0x8f,
 0x20,0x00,0xc0,0x4d,0x12,0x00,0xc0,0xe9,0x0c,0x00,0xc0,0x08,0x00,0x00,0xc0,
 0x0c,0x00,0x00,0x40,0x0e,0x00,0x00,0x40,0x0e,0x00,0x00,0x40,0x0e,0x00,0x00,
 0xc0,0x07,0x00,0x00,0xc0,0x07,0x00,0x00,0xc0,0x03,0x00,0x00,0xe0,0x01,0x00,
 0x00,0xf0,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,0x7c,0x01,0x00,0x00,0x3c,0x01,
 0x00,0x00,0x1e,0x01,0x00,0x00,0x8f,0x1f,0x00,0x00,0xcf,0x3f,0x00,0x00,0xe7,
 0x3f,0x00,0x00,0xe7,0x7a,0x00,0x00,0x67,0x72,0x00,0x00,0x67,0x62,0x00,0x00,
 0x6f,0x62,0x00,0x00,0x4e,0x64,0x00,0x00,0x8c,0x24,0x00,0x00,0x18,0x34,0x00,
 0x00,0x70,0x1c,0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x04,
 0x00,0x00,0x00,0x08,0x00,0x00,0xe0,0x08,0x00,0x00,0xf0,0x09,0x00,0x00,0xf0,
 0x09,0x00,0x00,0xf0,0x09,0x00,0x00,0xf0,0x08,0x00,0x00,0x60,0x04,0x00,0x00,
 0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
/*3*/       { 0x00,0x00,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0xc0,0x0f,
 0x00,0x00,0xc0,0x0d,0x00,0x00,0xc0,0x09,0x00,0x00,0xc0,0x08,0x00,0x00,0xc0,
 0x0c,0x00,0x00,0x40,0x0e,0x00,0x00,0x40,0x0e,0x00,0x00,0x40,0x0e,0x00,0x00,
 0xc0,0x07,0x00,0x00,0xc0,0x07,0x00,0x00,0xc0,0x03,0x00,0x00,0xe0,0x01,0x00,
 0x00,0xf0,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,0x7c,0x01,0x00,0x00,0x3c,0x01,
 0x00,0x00,0x1e,0x01,0x00,0x00,0x8f,0x1f,0x00,0x00,0xcf,0x3f,0x00,0x00,0xe7,
 0x3f,0x00,0x00,0xe7,0x7a,0x00,0x00,0x67,0x72,0x00,0x00,0x67,0x62,0x00,0x00,
 0x6f,0x62,0x00,0x00,0x4e,0x64,0x00,0x00,0x8c,0x24,0x00,0x00,0x18,0x34,0x00,
 0x00,0x70,0x1c,0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x04,
 0x00,0x00,0x00,0x08,0x00,0x00,0xe0,0x08,0x00,0x00,0xf0,0x09,0x03,0x00,0xf0,
 0x89,0x04,0x00,0xf0,0x89,0x03,0x00,0xf0,0x48,0x02,0x00,0x60,0x44,0x02,0x00,
 0xc0,0xc3,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

/*4*/      { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0x8c,0x03,0x00,0x00,0x06,0xc7,0x00,0x00,
 0x0f,0xe7,0x00,0x00,0x1f,0x6e,0x00,0x00,0x1f,0x0e,0x00,0x00,0x1f,0xce,0x00,
 0x00,0x0e,0xce,0x00,0x00,0x00,0xee,0x00,0x00,0x00,0x6f,0x00,0x00,0x00,0x07,
 0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0xc0,0x03,0x00,0x00,0xe0,
 0x01,0x00,0x00,0xf0,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,
 0x0f,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0x8c,0x03,0x00,0x00,0x06,0xc7,0x00,0x00,
 0x0f,0xe7,0x00,0x00,0x1f,0x6e,0x00,0x00,0x1f,0x0e,0x00,0x00,0x1f,0xce,0x00,
 0x00,0x0e,0xce,0x00,0x00,0x00,0xee,0x00,0x00,0x00,0x6f,0x00,0x00,0x00,0x07,
 0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0xc0,0x03,0x00,0x00,0xe0,
 0x01,0x00,0x00,0xf0,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,
 0x0f,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,
 0x00,0x24,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x12,0x00,
 0x00,0x00,0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0x8c,0x03,0x00,0x00,0x06,0xc7,0x00,0x00,
 0x0f,0xe7,0x00,0x00,0x1f,0x6e,0x00,0x00,0x1f,0x0e,0x00,0x00,0x1f,0xce,0x00,
 0x00,0x0e,0xce,0x00,0x00,0x00,0xee,0x00,0x00,0x00,0x6f,0x00,0x00,0x00,0x07,
 0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0xc0,0x03,0x00,0x00,0xe0,
 0x01,0x00,0x00,0xf0,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,
 0x0f,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc8,0x03,0x00,
 0x00,0x4c,0x00,0x00,0x00,0xe4,0x00,0x00,0x00,0x04,0x01,0x00,0x00,0x12,0x01,
 0x00,0x00,0xe7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,
 0x00,0x8c,0x03,0x00,0x00,0x06,0xc7,0x00,0x00,0x0f,0xe7,0x00,0x00,0x1f,0x6e,
 0x00,0x00,0x1f,0x0e,0x00,0x00,0x1f,0xce,0x00,0x00,0x0e,0xce,0x00,0x00,0x00,
 0xee,0x00,0x00,0x00,0x6f,0x00,0x00,0x00,0x07,0x00,0x00,0x80,0x07,0x00,0x00,
 0x80,0x07,0x00,0x00,0xc0,0x03,0x00,0x00,0xe0,0x01,0x00,0x00,0xf0,0x00,0x00,
 0x00,0x78,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,0x0f,0x00,0x00,0x80,0x01,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0x8c,0x03,
 0x00,0x00,0x06,0xc7,0x00,0x00,0x0f,0xe7,0x00,0x00,0x1f,0x6e,0x00,0x00,0x1f,
 0x0e,0x00,0x00,0x1f,0xce,0x00,0x00,0x0e,0xce,0x00,0x00,0x00,0xee,0x00,0x00,
 0x00,0x6f,0x00,0x00,0x00,0x07,0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x07,0x00,
 0x00,0xc0,0x03,0x00,0x00,0xe0,0x01,0x00,0x00,0xf0,0x00,0x00,0x00,0x78,0x00,
 0x00,0x00,0x1c,0x00,0x00,0x00,0x0f,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x2e,0x7c,0x00,0x00,0x2e,0xe6,0x00,0x00,0x2e,
 0xcf,0x01,0x00,0x2e,0xcf,0x01,0x00,0x2e,0xc6,0x01,0x00,0x2e,0xc0,0x01,0x00,
 0x2e,0xc0,0x01,0x00,0x2e,0xc2,0x01,0x00,0x2e,0xc2,0x00,0x00,0x2e,0xe6,0x00,
 0x00,0x2e,0x3f,0x00,0x00,0xae,0x03,0x00,0x00,0xae,0x03,0x00,0x00,0xae,0x03,
 0x00,0x00,0x2e,0x3f,0x00,0x00,0x2e,0xe6,0x00,0x00,0x2e,0xc2,0x00,0x00,0x2e,
 0xc2,0x01,0x00,0x2e,0xc0,0x01,0x00,0x2e,0xc0,0x01,0x00,0x2e,0xc6,0x01,0x00,
 0x2e,0xcf,0x01,0x00,0x2e,0xcf,0x01,0x00,0x2e,0xe6,0x00,0x00,0x2e,0x7c,0x00
 },
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2e,0x7c,0x00,
 0x00,0x2e,0xe6,0x00,0x00,0x2e,0xcf,0x01,0x00,0x2e,0xcf,0x01,0x00,0x2e,0xc6,
 0x01,0x00,0x2e,0xc0,0x01,0x00,0x2e,0xc0,0x01,0x00,0x2e,0xc2,0x01,0x00,0x2e,
 0xc2,0x00,0x00,0x2e,0xe6,0x00,0x00,0x2e,0x3f,0x00,0x00,0xae,0x03,0x00,0x00,
 0xae,0x03,0x00,0x00,0xae,0x03,0x00,0x00,0x2e,0x3f,0x00,0x00,0x2e,0xe6,0x00,
 0x00,0x2e,0xc2,0x00,0x00,0x2e,0xc2,0x01,0x00,0x2e,0xc0,0x01,0x00,0x2e,0xc0,
 0x01,0x00,0x2e,0xc6,0x01,0x00,0x2e,0xcf,0x01,0x00,0x2e,0xcf,0x01,0x00,0x2e,
 0xe6,0x00,0x00,0x2e,0x7c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x2e,0x7c,0x00,0x00,0x2e,0xe6,0x00,0x00,0x2e,0xcf,0x01,0x00,
 0x2e,0xcf,0x01,0x00,0x2e,0xc6,0x01,0x00,0x2e,0xc0,0x01,0x00,0x2e,0xc0,0x01,
 0x00,0x2e,0xc2,0x01,0x00,0x2e,0xc2,0x00,0x00,0x2e,0xe6,0x00,0x00,0x2e,0x3f,
 0x00,0x00,0xae,0x03,0x00,0x00,0xae,0x03,0x00,0x00,0xae,0x03,0x00,0x00,0x2e,
 0x3f,0x00,0x00,0x2e,0xe6,0x00,0x00,0x2e,0xc2,0x00,0x00,0x2e,0xc2,0x01,0x00,
 0x2e,0xc0,0x01,0x00,0x2e,0xc0,0x01,0x00,0x2e,0xc6,0x01,0x00,0x2e,0xcf,0x01,
 0x00,0x2e,0xcf,0x01,0x00,0x2e,0xe6,0x00,0x00,0x2e,0x7c,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2e,0x7c,0x00,0x00,0x2e,0xe6,
 0x00,0x00,0x2e,0xcf,0x01,0x00,0x2e,0xcf,0x01,0x00,0x2e,0xc6,0x01,0x00,0x2e,
 0xc0,0x01,0x00,0x2e,0xc0,0x01,0x00,0x2e,0xc2,0x01,0x00,0x2e,0xc2,0x00,0x00,
 0x2e,0xe6,0x00,0x00,0x2e,0x3f,0x00,0x00,0xae,0x03,0x00,0x00,0xae,0x03,0x00,
 0x00,0xae,0x03,0x00,0x00,0x2e,0x3f,0x00,0x00,0x2e,0xe6,0x00,0x00,0x2e,0xc2,
 0x00,0x00,0x2e,0xc2,0x01,0x00,0x2e,0xc0,0x01,0x00,0x2e,0xc0,0x01,0x00,0x2e,
 0xc6,0x01,0x00,0x2e,0xcf,0x01,0x00,0x2e,0xcf,0x01,0x00,0x2e,0xe6,0x00,0x00,
 0x2e,0x7c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x60,0x06,0x00,0x00,0x60,0x06,0x00,0x00,0x60,0x06,0x00,0x00,0x60,0x06,
 0x00,0x00,0x60,0x06,0x00,0x00,0x60,0x06,0x00,0x00,0x60,0x06,0x00,0x00,0x60,
 0x06,0x00,0x00,0x60,0x06,0x00,0x00,0x60,0x06,0x00,0x00,0x60,0x06,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
      };

static unsigned char note0Bits[] = { 0x38,0x4e,0x43,0x61,0x39,0x0e };
static unsigned char note1Bits[] = { 0x38,0x7e,0x7f,0x7f,0x3f,0x0e };
static unsigned char note2Bits[] = { 0x1c, 0x23, 0x43, 0x61, 0x62, 0x1c };

static unsigned char sharpBits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x90,0x00,0x90,0x00,0x90,0x00,0x90,
 0x00,0xd0,0x01,0xf8,0x01,0xb8,0x00,0x90,0x00,0x90,0x00,0x90,0x00,0xd0,0x01,
 0xf8,0x01,0xb8,0x00,0x90,0x00,0x90,0x00,0x90,0x00,0x10,0x00};
static unsigned char sharp2Bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x8c,0x01,0xdc,0x01,0x70,0x00,0x20,0x00,0x70,0x00,0xdc,0x01,
 0x8c,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
static unsigned char flatBits[] = {
 0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,
 0x00,0x10,0x00,0xf0,0x01,0x90,0x01,0x90,0x01,0xd0,0x00,0x50,0x00,0x30,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
static unsigned char flat2Bits[] = {
 0x11,0x00,0x11,0x00,0x11,0x00,0x11,0x00,0x11,0x00,0x11,0x00,0x11,0x00,0x11,
 0x00,0x11,0x00,0xff,0x01,0x99,0x01,0x99,0x01,0xdd,0x00,0x55,0x00,0x33,0x00,
 0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
static unsigned char natBits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x10,
 0x00,0x10,0x00,0x10,0x01,0xd0,0x01,0xf0,0x01,0x30,0x01,0x10,0x01,0x10,0x01,
 0xd0,0x01,0xf0,0x01,0x70,0x01,0x10,0x01,0x00,0x01,0x00,0x01,0x00,0x01};

static unsigned char flagBits[] = {
 0xc1,0xc1,0xc1,0xc3,0xc3,0xc7,0xce,0xdc,0xd8,0xf0,0xe0,0xe0,0xd0};

static unsigned char flagIBits[] = {
 0x10,0x20,0x20,0x30,0x18,0x1c,0x0e,0x07,0x03,0x03,0x01,0x01,0x01};

static unsigned char dotBits[] = { 0x2, 0x7, 0x2 };


//
//   pausen
//

static unsigned char restBits[6][46] = {
 { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x01,0xfe,
 0x01,0xfe,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00},

      {
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0xfe,0x01,
            0xfe,0x01,
            0xfe,0x01,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00},

 { 0x00,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0xc0,0x00,0xc0,0x01,0xe0,0x01,0xf0,
 0x01,0xf8,0x00,0x7c,0x00,0x38,0x00,0x30,0x00,0x20,0x00,0x40,0x00,0xf0,0x00,
 0xf8,0x01,0x38,0x00,0x18,0x00,0x10,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00},
      {
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x02,
            0x18,0x03,
            0x9c,0x01,
            0xdc,0x01,
            0xb8,0x01,
            0x80,0x00,
            0x80,0x00,
            0xc0,0x00,
            0xc0,0x00,
            0x40,0x00,
            0x60,0x00,
            0x60,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00,
            0x00,0x00
            },

 { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x18,0x01,0x9c,
 0x01,0xdc,0x01,0xb8,0x00,0x80,0x00,0x80,0x00,0xc6,0x00,0x67,0x00,0x77,0x00,
 0x6e,0x00,0x20,0x00,0x20,0x00,0x30,0x00,0x30,0x00,0x10,0x00,0x18,0x00,0x18,
 0x00},

 { 0x60,0x04,0x70,0x06,0x70,0x07,0xe0,0x02,0x00,0x02,0x00,0x03,0x18,0x01,0x9c,
 0x01,0xdc,0x01,0xb8,0x00,0x80,0x00,0x80,0x00,0xc6,0x00,0x67,0x00,0x77,0x00,
 0x2e,0x00,0x20,0x00,0x20,0x00,0x30,0x00,0x10,0x00,0x18,0x00,0x18,0x00,0x18,
 0x00}};

static const char* noteBits[7][23] =  {
{
"20 20 2 1",
". c none",
"# c #000000",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"........###.........",
"......###..#........",
".....##....#........",
".....#....##........",
".....#..###.........",
"......###...........",
"....................",
"...................."
},
{
"20 20 2 1",
". c none",
"# c #000000",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"........####........",
"......###..#........",
".....##....#........",
".....#....##........",
".....#..###.........",
"......###...........",
"....................",
"...................."
},
{
"20 20 2 1",
". c none",
"# c #000000",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"........####........",
"......######........",
".....#######........",
".....#######........",
".....######.........",
"......###...........",
"....................",
"...................."
},
{
"    20    20        2            1",
". c none",
"# c #000000",
"...........##.......",
"...........#.#......",
"...........#..#.....",
"...........#...#....",
"...........#...#....",
"...........#...#....",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"........####........",
"......######........",
".....#######........",
".....#######........",
".....######.........",
"......###...........",
"....................",
"...................."
},
{
"    20    20        2            1",
". c none",
"# c #000000",
"...........##.......",
"...........#.#......",
"...........#..#.....",
"...........##..#....",
"...........#.#.#....",
"...........#..#.....",
"...........#...#....",
"...........#...#....",
"...........#........",
"...........#........",
"...........#........",
"...........#........",
"........####........",
"......######........",
".....#######........",
".....#######........",
".....######.........",
"......###...........",
"....................",
"...................."
},
{
"    20    20        2            1",
". c none",
"# c #000000",
"...........##.......",
"...........#.#......",
"...........#..#.....",
"...........##..#....",
"...........#.#.#....",
"...........#..#.....",
"...........##..#....",
"...........#.#.#....",
"...........#..#.....",
"...........#...#....",
"...........#...#....",
"...........#...#....",
"........####........",
"......######........",
".....#######........",
".....#######........",
".....######.........",
"......###...........",
"....................",
"...................."
},
{
"    20    20        2            1",
". c none",
"# c #000000",
"...........##.......",
"...........#.#......",
"...........#..#.....",
"...........##..#....",
"...........#.#.#....",
"...........#..#.....",
"...........##..#....",
"...........#.#.#....",
"...........#..#.....",
"...........##..#....",
"...........#.#.#....",
"...........#..#.....",
"........####.. #....",
"......######...#....",
".....#######........",
".....#######........",
".....######.........",
"......###...........",
"....................",
"...................."
}};

static const char* flipNoteBits[16] =  {
"16 12 3 1",
". c none",
"# c none",
"a c #000000",
".#######a#######",
".#######a#######",
".#######a#######",
".#######a#######",
".#######a#######",
".#####aaa#######",
".####aaaa#######",
".####aaa########",
".####a##########",
".####a##########",
".####a##########",
".####a##########"
};

static const char* upVoiceBits[16] =  {
"16 12 2 1",
". c none",
"a c #000000",
"................",
"....a...........",
"....a...........",
"....a...........",
"....a.....a.....",
"....a....aaa....",
"....a...aaaaa...",
"..aaa..aaaaaaa..",
".aaaa...........",
".aaa............",
"................",
"................"
};

static const char* downVoiceBits[16] =  {
"16 12 2 1",
". c none",
"a c #000000",
"................",
"....a...........",
"....a...........",
"....a...........",
"....a..aaaaaaa..",
"....a...aaaaa...",
"....a....aaa....",
"..aaa.....a.....",
".aaaa...........",
".aaa............",
"................",
"................"
};

static const char* snoteBits[9][16] =  {
{
"    16    12        3            1",
". c none",
"# c none",
"a c #000000",
"...............#",
".###############",
".###############",
".###############",
".###############",
".###############",
".#####aaa#######",
".####aa#aa######",
".####aa#aa######",
".#####aaa#######",
".###############",
"################"
},{
"    16    12        3            1",
". c none",
"# c none",
"a c #000000",
"...............#",
".#######a#######",
".#######a#######",
".#######a#######",
".#######a#######",
".#######a#######",
".#######a#######",
".#####aaa#######",
".####a..a#######",
".####aaa########",
".###############",
"################"
},{
"    16    12        3            1",
". c none",
"# c none",
"a c #000000",
"...............#",
".#######a#######",
".#######a#######",
".#######a#######",
".#######a#######",
".#######a#######",
".#######a#######",
".#####aaa#######",
".####aaaa#######",
".####aaa########",
".###############",
"################"
},{
"    16    12        3            1",
". c none",
"# c none",
"a c #000000",
"...............#",
".#######aa######",
".#######a#a#####",
".#######a##a####",
".#######a##a####",
".#######a##a####",
".#######a##a####",
".#####aaa#######",
".####aaaa#######",
".####aaa########",
".###############",
"################"
},{
"    16    12        3            1",
". c none",
"# c none",
"a c #000000",
"...............#",
".#######aa######",
".#######a#a#####",
".#######aa#a####",
".#######a#aa####",
".#######a##a####",
".#######a##a####",
".#####aaa#######",
".####aaaa#######",
".####aaa########",
".###############",
"################"
},{
"    16    12        3            1",
". c none",
"# c none",
"a c #000000",
"...............#",
".#######aa######",
".#######a#a#####",
".#######aa#a####",
".#######a#aa####",
".#######aa#a####",
".#######a#aa####",
".#####aaa##a####",
".####aaaa#######",
".####aaa########",
".###############",
"################"
},{
"    16    12        3            1",
". c none",
"# c none",
"a c #000000",
"...............#",
".#######aa######",
".#######a#a#####",
".#######aa#a####",
".#######a#aa####",
".#######aa#a####",
".#######a#aa####",
".#####aaaa#a####",
".####aaaa#aa####",
".####aaa###a####",
".###############",
"################"
},{
"    16    12        3            1",
". c none",
"# c none",
"a c #000000",
"...............#",
".###############",
".###############",
".###############",
".###############",
".######aa#######",
".######aa#######",
".###############",
".###############",
".###############",
".###############",
"################"
},{
"16 12 3 1",
". c none",
"# c none",
"a c #000000",
"...............#",
".###############",
".###############",
".#####aaaaa#####",
".#######a#######",
".#######a#######",
".#######a#######",
".#######a#######",
".#######a#######",
".###############",
".###############",
"################"
}};

static const char* enhBits[5][16] =  {
{
"    16    12        2            1",
". c None",
"# c #000000",
"................",
"................",
"....#...#.......",
"....#...#.......",
"....#...#.......",
"....#...#.......",
"....########....",
"....#.#.#.#.....",
"....##..##......",
"....#...#.......",
"................",
"................"
},{
"    16    12        2            1",
". c None",
"# c #000000",
"................",
"................",
".......#........",
".......#........",
".......#........",
".......#........",
".......####.....",
".......#.#......",
".......##.......",
".......#........",
"................",
"................"
},{
"    16    12        2            1",
". c None",
"# c #000000",
"................",
"................",
"................",
"....#..#........",
"....##.#........",
"....####..##....",
"....#.##.#..#...",
"....#..#.#..#...",
"....#..#..##....",
"................",
"................",
"................"
},{
"    16    12        2            1",
". c None",
"# c #000000",
"................",
"................",
"......#.#.......",
"......#.##......",
".....####.......",
"......#.#.......",
"......#.##......",
".....####.......",
"......#.#.......",
"......#.........",
"................",
"................"
},{
"    16    12        2            1",
". c None",
"# c #000000",
"................",
"................",
"................",
"................",
"....##...##.....",
"......#.#.......",
".......#........",
"......#.#.......",
"....##...##.....",
"................",
"................",
"................"
}};


static const char* configBits[] = {
"16 12 2 1",
". c None",
"x c #00ff00",
"................",
"................",
"....xxxxxxxx....",
"...x........x...",
"...x............",
"...x............",
"...x............",
"...x............",
"...x........x...",
"...,xxxxxxxx....",
"................",
"................"
};


static const char* notenposBits[] =  {
"14 38 2 1",
". c none",
"# c #ff0000",
"##############",
".############.",
"..##########..",
"...########...",
"....######....",
".....####.....",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......",
"......##......"
};

static const char* notedotBits[] =  {
"20 20 2 1",
". c none",
"# c #000000",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"..............##....",
"..............##....",
"....................",
"...................."
};

static const char* note3Bits[] =  {
"20 20 2 1",
". c none",
"# c #000000",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"..............###...",
".................#..",
"...............##...",
".................#..",
"..............###..."
};

static const char* dyn_xpm[12][24] = { {
"20 20 3 1",
" 	c None",
".	c None",
"+	c #000000",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"++++++.++++++.++++++",
"+.+..+++.+..+++.+..+",
".++..+..++..+..++..+",
".+..++..+..++..+..++",
"+++++..+++++..+++++.",
"++.....++.....++....",
"+.....++.....++.....",
"++...++++...++++....",
"....................",
"....................",
"....................",
"....................",
"...................."},

{
"20 20 3 1",
" 	c None",
".	c None",
"+	c #000000",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....++++++.++++++...",
"...++.+..+++.+..++..",
".....++..+..++..+...",
".....+..++..+..++...",
"....+++++..+++++....",
"....++.....++.......",
"...++.....++........",
"..++++...++++.......",
"....................",
"....................",
"....................",
"....................",
"...................."},

{
"20 20 3 1",
" 	c None",
".	c None",
"+	c #000000",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"........++++++......",
".......++.+..++.....",
"......+..++..+......",
".........+..++......",
"........+++++.......",
"........++..........",
".......++...........",
".....+++++..........",
"....................",
"....................",
"....................",
"....................",
"...................."},

{
"20 20 3 1",
" 	c None",
".	c None",
"+	c #000000",
"....................",
"....................",
"....................",
"....................",
"....................",
"..........+++.......",
".........++.++......",
".........++.........",
".......+++++........",
"........+++.........",
"........++..........",
"........++..........",
"........++..........",
".......++...........",
".......++...........",
".....+++............",
"....................",
"....................",
"....................",
"...................."},

{
"20 20 3 1",
" 	c None",
".	c None",
"+	c #000000",
"....................",
"....................",
"....................",
"....................",
"....................",
"........+++..+++....",
".......++.++++.++...",
".......++...++......",
".....++++++++++.....",
"......+++..+++......",
"......++...++.......",
"......++...++.......",
"......++...++.......",
".....++...++........",
".....++...++........",
"...+++..+++.........",
"....................",
"....................",
"....................",
"...................."},

{
"20 20 3 1",
" 	c None",
".	c None",
"+	c #000000",
"....................",
"....................",
"....................",
"....................",
"....................",
"......+++..+++..+++.",
".....++.++++.++++.++",
".....++...++...++...",
"...+++++++++++++++..",
"....+++..+++..+++...",
"....++...++...++....",
"....++...++...++....",
"....++...++...++....",
"...++...++...++.....",
"...++...++...++.....",
".+++..+++..+++......",
"....................",
"....................",
"....................",
"...................."},

{
"20 20 3 1",
" 	c None",
".	c None",
"+	c #000000",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"....................",
"..++.+.+.+...++++++.",
".+.++++++++.++.+..++",
"...++.++.++...++..+.",
"..++.++.++.+..+..++.",
"..++.++.+++..+++++..",
".............++.....",
"............++......",
"..........+++++.....",
"....................",
"....................",
"....................",
"...................."},

{
"20 20 3 1",
" 	c None",
".	c None",
"+	c #000000",
"....................",
"....................",
"....................",
"....................",
"....................",
"...............+++..",
"..............++.++.",
"..............++....",
"..++.+.+.+..+++++...",
".+.++++++++..+++....",
"...++.++.++..++.....",
"..++.++.++.+.++.....",
"..++.++.+++..++.....",
"............++......",
"............++......",
"..........+++.......",
"....................",
"....................",
"....................",
"...................."},

{
"20 20 3 1",
" 	c None",
".	c None",
"+	c #000000",
"....................",
"....................",
"....................",
"....................",
"....................",
"..........+++.......",
".........++.++......",
".........++.........",
".....+++++++.+++....",
"....++..++..+.+.....",
"....++..++...+......",
".....++.++..+.+.....",
"..+..++.++.++++.....",
"...+++.++...........",
".......++...........",
".....+++............",
"....................",
"....................",
"....................",
"...................."},

{
"20 20 3 1",
" 	c None",
".	c None",
"+	c #000000",
"....................",
"....................",
"....................",
"....................",
"....................",
".............+++....",
"............++.++...",
"............++......",
"........+++++++.....",
".......++..++.......",
".......++..++.......",
"........++.++.......",
".....+..++.++.......",
"......+++.++........",
"..........++........",
"........+++.........",
"....................",
"....................",
"....................",
"...................."},

{
"20 20 3 1",
" 	c None",
".	c None",
"+	c #000000",
"....................",
"....................",
"....................",
"....................",
"....................",
".........+++..+++...",
"........++.++++.....",
"........++...++.....",
"....+++++++++++++...",
"...++..++...++......",
"...++..++...++......",
"....++.++...++......",
".+..++.++...++......",
"..+++.++...++.......",
"......++...++.......",
"....+++..+++........",
"....................",
"....................",
"....................",
"...................."},

{
"20 20 2 1",
".	c None",
"+	c #000000",
"....................",
"....................",
"....................",
"....................",
"....................",
".......+++..........",
"......++.++.........",
"......++............",
"....+++++..++++++...",
".....+++..++.+..++..",
".....++..+..++..+...",
".....++.....+..++...",
".....++....+++++....",
"....++.....++.......",
"....++....++........",
"..+++...+++++.......",
"....................",
"....................",
"....................",
"...................."}
      };

static const char *ts44_xpm[] = {
"20 20 2 1",
". c #000000",
"g c None",
"gggggggggggggggggggg",
"gggggggggggggggggggg",
"gggggggggggggggggggg",
"gggggggggggggggggggg",
"gggggggggggggggggggg",
"gggggggggggggggggggg",
"ggggggg......ggggggg",
"gggggg....gg..gggggg",
"gggggg...ggg..gggggg",
"ggggg....ggg...ggggg",
"ggggg...gggg..gggggg",
"ggggg...gggggggggggg",
"ggggg...gggggggggggg",
"ggggg...gggggggggggg",
"ggggg....ggggggggggg",
"ggggg....gggg..ggggg",
"gggggg...ggg..gggggg",
"ggggggg......ggggggg",
"gggggggggggggggggggg",
"gggggggggggggggggggg",
"gggggggggggggggggggg"
};

static const char *ts22_xpm[] = {
"20 20 2 1",
". c #000000",
"g c None",
"gggggggggggggggggggg",
"gggggggggggggggggggg",
"gggggggggggggggggggg",
"gggggggggggggggggggg",
"gggggggggg.ggggggggg",
"gggggggggg.ggggggggg",
"ggggggg......ggggggg",
"gggggg.....g..gggggg",
"gggggg...g.g..gggggg",
"ggggg....g.g...ggggg",
"ggggg...gg.g..gggggg",
"ggggg...gg.ggggggggg",
"ggggg...gg.ggggggggg",
"ggggg...gg.ggggggggg",
"ggggg....g.ggggggggg",
"ggggg....g.gg..ggggg",
"gggggg...g.g..gggggg",
"ggggggg......ggggggg",
"gggggggggg.ggggggggg",
"gggggggggg.ggggggggg",
"gggggggggggggggggggg"
};

static const char *bracket_xpm[] = {
"8 85 2 1",
". c #000000",
"j c None",
"jjjjjjj.",
"jjjjjjj.",
"jjjjjj.j",
"jjjjjj.j",
"jjjjj..j",
"jjjjj.jj",
"jjjj..jj",
"jjjj.jjj",
"jjj..jjj",
"jjj..jjj",
"jjj..jjj",
"jjj..jjj",
"jjj..jjj",
"jj...jjj",
"jj...jjj",
"jj...jjj",
"jj...jjj",
"jj...jjj",
"jj...jjj",
"jj...jjj",
"jj....jj",
"jj....jj",
"jj....jj",
"jjj...jj",
"jjj...jj",
"jjj....j",
"jjj....j",
"jjj....j",
"jjjj...j",
"jjjj...j",
"jjjj...j",
"jjjj...j",
"jjjj...j",
"jjjj...j",
"jjjj..jj",
"jjjj..jj",
"jjjj..jj",
"jjjj.jjj",
"jjj.jjjj",
"jj.jjjjj",
"jj.jjjjj",
"j.jjjjjj",
".jjjjjjj",
"j.jjjjjj",
"jj.jjjjj",
"jjjjjjjj",
"jjj.jjjj",
"jjjj.jjj",
"jjjj..jj",
"jjjj..jj",
"jjjj..jj",
"jjjj...j",
"jjjj...j",
"jjjj...j",
"jjjj...j",
"jjjj...j",
"jjjj...j",
"jjj....j",
"jjj....j",
"jjj....j",
"jjj...jj",
"jjj...jj",
"jj....jj",
"jj....jj",
"jj....jj",
"jj...jjj",
"jj...jjj",
"jj...jjj",
"jj...jjj",
"jj...jjj",
"jj...jjj",
"jj...jjj",
"jjj..jjj",
"jjj..jjj",
"jjj..jjj",
"jjj..jjj",
"jjj..jjj",
"jjjj.jjj",
"jjjj..jj",
"jjjjj.jj",
"jjjjj..j",
"jjjjjj.j",
"jjjjjj.j",
"jjjjjjj.",
"jjjjjjj."
};

QBitmap* keyBM[14];
QBitmap* note0BM;
QBitmap* note1BM;
QBitmap* note2BM;

Sprite* sharpSprite;
Sprite* sharp2Sprite;
Sprite* natSprite;
Sprite* flatSprite;
Sprite* flat2Sprite;

QBitmap* flagBM;
QBitmap* flagIBM;
QBitmap* dotBM;
QBitmap* restBM[6];
QPixmap* noteBM[7];
QPixmap* snoteBM[9];
QPixmap* enhBM[5];
QPixmap* notenposBM;
QPixmap* configBM;
QPixmap* notedotBM;
QPixmap* note3BM;
QPixmap* dynBM[12];
QPixmap* ts44;
QPixmap* ts22;
QPixmap* bracketBM;
QPixmap* flipNote;
QPixmap* upVoice;
QPixmap* downVoice;

//---------------------------------------------------------
//   initSymbols
//---------------------------------------------------------

void initSymbols()
      {
      if (initialized)
            return;
      for (int i = 0; i < 14; ++i) {
            keyBM[i]  = new QBitmap(32, 45, keyBits[i], true);
            keyBM[i]->setMask(*keyBM[i]);
            }

      note0BM = new QBitmap(7, 6, note0Bits, true);
      note0BM->setMask(*note0BM);

      note1BM = new QBitmap(7, 6, note1Bits, true);
      note1BM->setMask(*note1BM);

      note2BM = new QBitmap(7, 6, note2Bits, true);
      note2BM->setMask(*note2BM);

      sharpSprite  = new Sprite(9, 21, sharpBits,  QPoint(5, 12));
      sharp2Sprite = new Sprite(9, 21, sharp2Bits, QPoint(5, 12));
      flatSprite   = new Sprite(9, 21, flatBits,   QPoint(5, 12));
      flat2Sprite  = new Sprite(9, 21, flat2Bits,  QPoint(5, 12));
      natSprite    = new Sprite(9, 22, natBits,    QPoint(5, 12));

      flagBM = new QBitmap(6, 13, flagBits, true);
      flagBM->setMask(*flagBM);

      flagIBM = new QBitmap(6, 13, flagIBits, true);
      flagIBM->setMask(*flagIBM);

      dotBM = new QBitmap(3, 3, dotBits, true);
      dotBM->setMask(*dotBM);

      for (int i = 0; i < 6; ++i) {
            restBM[i] = new QBitmap(11, 23, restBits[i], true);
            restBM[i]->setMask(*restBM[i]);
            }
      for (int i = 0; i < 7; ++i)
            noteBM[i] = new QPixmap(noteBits[i]);
      for (int i = 0; i < 9; ++i)
            snoteBM[i] = new QPixmap(snoteBits[i]);
      for (int i = 0; i < 5; ++i)
            enhBM[i] = new QPixmap(enhBits[i]);
      for (int i = 0; i < 12; ++i)
            dynBM[i] = new QPixmap(dyn_xpm[i]);
      notenposBM  = new QPixmap(notenposBits);
      configBM    = new QPixmap(configBits);
      notedotBM   = new QPixmap(notedotBits);
      note3BM     = new QPixmap(note3Bits);
      ts44        = new QPixmap(ts44_xpm);
      ts22        = new QPixmap(ts22_xpm);
      bracketBM   = new QPixmap(bracket_xpm);
      flipNote    = new QPixmap(flipNoteBits);
      upVoice   = new QPixmap(upVoiceBits);
      downVoice   = new QPixmap(downVoiceBits);
      initialized = true;
      }

