//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: ctrledit.h,v 1.1.1.1 2003/10/29 10:05:21 wschweer Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __CTRL_EDIT_H__
#define __CTRL_EDIT_H__

#include <qwidget.h>
#include "ctrlcanvas.h"
#include "song.h"

class MidiEditor;
class QLabel;
class QToolButton;
class CtrlView;
class CtrlPanel;
class Xml;

//---------------------------------------------------------
//   CtrlEdit
//---------------------------------------------------------

class CtrlEdit : public QWidget {
      CtrlCanvas* canvas;
      CtrlPanel* panel;
      Q_OBJECT

   private slots:
      void destroy();

   public slots:
      void setTool(int tool);
      void setXPos(int val) { canvas->setXPos(val); }
      void setXMag(int val) { canvas->setXMag(val); }
      void setCanvasWidth(int w) { canvas->setFixedWidth(w); }
      void setKeyfilter(const char k) { canvas->setKeyfilter(k); }

   signals:
      void timeChanged(int);
      void destroyedCtrl(CtrlEdit*);
      void enterCanvas();
      void yposChanged(int);

   public:
      CtrlEdit(QWidget*, MidiEditor* e, int xmag,
         bool expand = false, const char* name = 0);
      void readStatus(Xml&);
      void writeStatus(int, Xml&);
      };

#endif

