//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: midisyncimpl.cpp,v 1.1 2002/01/30 14:54:03 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "midisyncimpl.h"
#include "globals.h"
// #include "seq.h"
#include <qspinbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>

//---------------------------------------------------------
//   extSyncChanged
//---------------------------------------------------------

void MidiSyncConfig::extSyncChanged(bool val)
      {
      intSync->setChecked(!val);
      acceptMTCCheckbox->setEnabled(val);
      acceptMCCheckbox->setEnabled(val);
      }

//---------------------------------------------------------
//   intSyncChanged
//---------------------------------------------------------

void MidiSyncConfig::intSyncChanged(bool val)
      {
      extSync->setChecked(!val);
      acceptMTCCheckbox->setEnabled(!val);
      acceptMCCheckbox->setEnabled(!val);
      }

//---------------------------------------------------------
//   MidiSyncConfig
//    Midi Sync Config
//---------------------------------------------------------

MidiSyncConfig::MidiSyncConfig(QWidget* parent=0, const char* name=0)
  : MidiSyncConfigBase(parent, name)
      {
      connect(okButton, SIGNAL(clicked()), SLOT(ok()));
      connect(applyButton, SIGNAL(clicked()), SLOT(apply()));
      connect(cancelButton, SIGNAL(clicked()), SLOT(cancel()));

      connect(extSync, SIGNAL(toggled(bool)), SLOT(extSyncChanged(bool)));
      connect(intSync, SIGNAL(toggled(bool)), SLOT(intSyncChanged(bool)));

      devId->setValue(deviceId);
      syncPort->setValue(extSyncPort + 1);
      mtcSync->setChecked(genMTCSync);
      mcSync->setChecked(genMCSync);
      midiMachineControl->setChecked(genMMC);
      acceptMCCheckbox->setChecked(acceptMC);
      acceptMTCCheckbox->setChecked(acceptMTC);

      mtcSyncType->setCurrentItem(mtcType);
      syncSrc->setButton(int(extSyncFlag.value()));

      mtcOffH->setValue(mtcOffset.h());
      mtcOffM->setValue(mtcOffset.m());
      mtcOffS->setValue(mtcOffset.s());
      mtcOffF->setValue(mtcOffset.f());
      mtcOffSf->setValue(mtcOffset.sf());

      bool ext = extSyncFlag.value();
      acceptMTCCheckbox->setEnabled(ext);
      acceptMCCheckbox->setEnabled(ext);
      }

//---------------------------------------------------------
//   ok Pressed
//---------------------------------------------------------

void MidiSyncConfig::ok()
      {
      apply();
      cancel();
      }

//---------------------------------------------------------
//   cancel Pressed
//---------------------------------------------------------

void MidiSyncConfig::cancel()
      {
      close(false);
      }

//---------------------------------------------------------
//   apply Pressed
//---------------------------------------------------------

void MidiSyncConfig::apply()
      {
      deviceId    = devId->value();
      extSyncPort = syncPort->value() - 1;
      genMTCSync  = mtcSync->isChecked();
      genMCSync   = mcSync->isChecked();
      genMMC      = midiMachineControl->isChecked();

      mtcType     = mtcSyncType->currentItem();
      extSyncFlag.setValue(extSync->isChecked());

      mtcOffset.setH(mtcOffH->value());
      mtcOffset.setM(mtcOffM->value());
      mtcOffset.setS(mtcOffS->value());
      mtcOffset.setF(mtcOffF->value());
      mtcOffset.setSf(mtcOffSf->value());

      acceptMC = acceptMCCheckbox->isChecked();
      acceptMTC = acceptMTCCheckbox->isChecked();
      }
