//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: ssource.h,v 1.2 2001/11/20 15:19:32 muse Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __SSOURCE_H__
#define __SSOURCE_H__

#include <qobject.h>

#ifndef AUDIO_CHANNELS
#define AUDIO_CHANNELS 2  // max channels: stereo
#endif

//---------------------------------------------------------
//   SoundSource
//---------------------------------------------------------

class SoundSource : public QObject {
      Q_OBJECT
      bool _mute;
      bool _soloMute;
      int _curActivity;       //tmp value
      int _channels;          // 1 - mono, 2 stereo

   protected:
      int _activity[AUDIO_CHANNELS];
      int _peak[AUDIO_CHANNELS];

   public slots:
      void resetPeaks();
      void resetMeter();

   public:
      SoundSource();
      SoundSource(const SoundSource& s);
      bool mute() const;
      bool soloMute() const;

      virtual void setMute(bool val);
      virtual void setSolo(bool val);

      int channels() const;
      virtual void setChannels(int val);

      void setActivity(int v, int c=0);
      void addActivity(int v, int c=0);

      // for midi (obsolete?):
      int curActivity() const;
      void setCurActivity(int v);

      int peak(int channel);
      int activity(int channel=0);
      };
#endif
