//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: midithreadp.h,v 1.2 2001/11/20 15:19:31 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

enum State {IDLE, PLAY, START_PLAY, SYNC, PRECOUNT};

class EventList;
class MidiEvent;

//---------------------------------------------------------
//   MidiThreadPrivate
//---------------------------------------------------------

struct MidiThreadPrivate {
      State state;
      int timerFd;
      int sigFd;

      // play values:
      int playTickPos;        // current midi tick position in song
      int rtcStartTick;
      int endSlice;
      EventList* playEvents;
      EventList* stuckNotes;
      bool controlChanged;
      int recTick;            // ext sync tick position
      int lastTickPos;        // position of last sync tick

      // record values:
      int curPitch, curVelo;  // Note Input for step recording etc.
      double startTime;
      int recStartTick;
      bool loopPassed;

      // run values:
      int midiTick;           // free running midi tick position
      int midiTickStart;      // midi tick at last tempo change
      int rtcTick;
      int rtcTickStart;       // rtc tick at last tempo change
      int midiSync;           // next midi sync pos in midi ticks
      int realRtcTicks;       // current rtc tick rate 1/sec
      int tempoSN;            // last tempo serial number to track
                              //    tempo changes
      double mclock1, mclock2;

      int midiClick;
      int clickno;
      int clicksMeasure;
      int ticksBeat;

      void startPlay();
      void stopPlay();
      void seek(int pos);
      void playEvent(MidiEvent* event);
      void processTimerTick();
      void initDevices();
      void realtimeSystemInput(int, int);
      void processMidiTick();
      };

