//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: midieditor.h,v 1.2 2001/11/20 15:19:31 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MIDIEDITOR_H__
#define __MIDIEDITOR_H__

#include "sig.h"
#include "cobject.h"

class PartList;
class Xml;
class QGridLayout;
class QWidget;
class QColor;
class EventCanvas;
class ScrollScale;
class CtrlEdit;
class MTScale;
class WaveView;

//---------------------------------------------------------
//   MidiEditor
//---------------------------------------------------------

class MidiEditor : public TopWin  {
      PartList* _pl;
      std::list<int> _parts;
      Q_OBJECT

   protected:
      ScrollScale* hscroll;
      ScrollScale* vscroll;
      MTScale* time;
      EventCanvas* canvas;
      WaveView* wview;

      std::list<CtrlEdit*> ctrlEditList;
      int _quant, _raster;
      QGridLayout* mainGrid;
      QWidget* mainw;
      virtual void readStatus(Xml&);
      virtual void writeStatus(int, Xml&) const;
      void writePartList(int, Xml&) const;
      void genPartlist();

   public slots:
      void songChanged(int type);

   public:
      MidiEditor(int, int, PartList*,
         QWidget* parent = 0, const char* name = 0);
      ~MidiEditor();

      int rasterStep(int tick) const { return sigmap.rasterStep(tick, _raster); }
      int quantVal(int v) const;
      int rasterVal(int v)  const { return sigmap.raster(v, _raster);  }
      int rasterVal1(int v) const { return sigmap.raster1(v, _raster); }
      int rasterVal2(int v) const { return sigmap.raster2(v, _raster); }
      int quant() const       { return _quant; }
      void setQuant(int val)  { _quant = val; }
      int raster() const      { return _raster; }
      void setRaster(int val) { _raster = val; }
      PartList* parts()       { return _pl;  }
      };

#endif

