//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: help.cpp,v 1.1 2002/01/30 14:10:07 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "app.h"
#include "help.h"
#include "globals.h"
#include "icons.h"

#include <stack>
#include <qstatusbar.h>
#include <qpixmap.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qiconset.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qstylesheet.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qapplication.h>
#include <qcombobox.h>
#include <qevent.h>
#include <qlineedit.h>
#include <qobjectlist.h>
#include <qfileinfo.h>
#include <qfile.h>
#include <qdatastream.h>
#include <qprinter.h>
#include <qsimplerichtext.h>
#include <qpaintdevicemetrics.h>
#include <qsplitter.h>
#include <qlistbox.h>
#include <qtabwidget.h>
#include <qpainter.h>
#include <qlistview.h>
// #include <fcntl.h>
#include <unistd.h>

#include <ctype.h>

struct Contents {
      const char* name;
      const char* url;
      };

static const Contents contents[] = {
      { "Arranger", "arranger.html" },
      { "Pianoroll Editor", "pianoroll.html" },
      { "Drum Editor", "drumedit.html" },
      { "List Editor", "listedit.html" },
      { "ScoreEditor", "scoreedit.html" },
      { "Transport Panel", "transport.html" },
      { "Create New Song", "newsong.html" },
      { "Record Events", "record.html" },
      { "Step Recording", "steprecord.html" },
      { 0, 0, }
      };

//---------------------------------------------------------
//   helpViewer
//---------------------------------------------------------

void MusE::helpBrowser()
      {
      if (helpViewer == 0) {
            QString lang = getenv("LANG");
            QString museHelp = museGlobalShare + "/html/toc_" + lang + ".txt";
            if (access(museHelp.latin1(), R_OK) != 0) {
                  QString info(tr("no help found at: "));
                  info += museHelp;
                  QMessageBox::critical(this, tr("MusE: Open Help"), info);
                  return;
                  }
            helpViewer = new HelpWindow(museHelp, museGlobalShare + "/html");
            }
      helpViewer->show();
      }

//---------------------------------------------------------
//   HelpWindow
//---------------------------------------------------------

HelpWindow::HelpWindow(const QString& home_, const QString& _path, QWidget* parent, const char *name)
   : MainWindow(parent, name, WType_TopLevel)
      {
      readBookmarks();

      fileList = path.entryList();

      QSplitter* split = new QSplitter(this);
      setCentralWidget(split);

      tab  = new QTabWidget(split);
      tab->setMinimumWidth(10);
      split->setResizeMode(tab, QSplitter::Stretch);

      contentsList  = new QListView(tab, "toc");
      contentsList->setRootIsDecorated(true);
      contentsList->setSelectionMode(QListView::Single);
      contentsList->setSorting(-1, false);
      contentsList->addColumn(tr("Table of Contents"));
      connect(contentsList, SIGNAL(clicked(QListViewItem*)),
         this, SLOT(contentsSelected(QListViewItem*)));

      indexList     = new QListBox(tab, "indexlist");
      bookmarkList  = new QListBox(tab, "bookmarks");
      connect(bookmarkList, SIGNAL(clicked(QListBoxItem*)),
         this, SLOT(bookmarkSelected(QListBoxItem*)));

      //
      //  read index
      //
      FILE* f = fopen(home_.latin1(), "r");
      if (f == 0) {
            QString info(tr("no help found at: "));
            info += home_;
            QMessageBox::critical(this, tr("MusE: Open index"), info);
            return;
            }
      std::stack<QListViewItem*> istack;
      int level = 0;
      while (!feof(f)) {
            bool expandable = false;
            int nlevel = 0;
            char buffer[1024];
            char* p1 = fgets(buffer, 1024, f);
            if (p1 == 0)
                  break;
            if (*p1 == 0 || *p1 == '\n' || *p1 == '#')
                  continue;
            while (isspace(*p1)) {
                  ++p1;
                  ++nlevel;
                  }
            if (*p1 == '+') {
                  expandable = true;
                  ++p1;
                  }
            while (isspace(*p1))
                  ++p1;
            bool quotes = false;
            if (*p1 == '"') {
                  quotes = true;
                  ++p1;
                  }
            if (nlevel > level)
                  nlevel = level;
            if (nlevel < level) {
                  while (!istack.empty() && nlevel < level) {
                        istack.pop();
                        --level;
                        }
                  level = nlevel;
                  }
            char* p2 = p1;
            ++p2;
            while(*p2) {
                  if (quotes) {
                        if (*p2 == '"')
                              break;
                        }
                  else {
                        if (isspace(*p2))
                              break;
                        }
                  ++p2;
                  }
            *p2 = 0;
            ++p2;
            while(isspace(*p2))
                  ++p2;
            QListViewItem* item;
            QString qp1(p1);
            QString qp2(p2);
            qp2 = qp2.stripWhiteSpace();
            if (qp2[0] == '"')
                  qp2 = qp2.mid(1, qp2.length()-2);
            if (level)
                  item = new QListViewItem(istack.top(), qp1, qp2);
            else
                  item = new QListViewItem(contentsList, qp1, qp2);
            if (expandable) {
                  item->setExpandable(true);
                  istack.push(item);
                  level = nlevel+1;
                  }
            }
      fclose(f);
      tab->addTab(contentsList, tr("TOC"));

      tab->addTab(indexList, tr("IDX"));
      tab->addTab(bookmarkList, tr("BM"));
      browser = new QTextBrowser(split);
      QValueList<int> sizes;
      sizes.append(140);
      sizes.append(610);
      split->setSizes(sizes);

      browser->mimeSourceFactory()->setFilePath(_path);
      browser->setFrameStyle(QFrame::Panel | QFrame::Sunken);
      connect(browser, SIGNAL(textChanged()), SLOT(textChanged()));
      connect(browser, SIGNAL(highlighted(const QString&)),
             statusBar(), SLOT(message(const QString&)));

      resize(750,700);
      setToolBarsMovable(false);

      QPopupMenu* file = new QPopupMenu(this);
      file->insertItem(tr("&New Window"), this, SLOT(newWindow()), ALT | Key_N);
      file->insertItem(tr("&Open File"), this, SLOT(openFile()), ALT | Key_O);
      file->insertItem(tr("&Print"), this, SLOT(print()), ALT | Key_P);
      file->insertSeparator();
      file->insertItem(tr("&Close"), this, SLOT(close()), ALT | Key_Q);
      file->insertItem(tr("E&xit"), qApp, SLOT(closeAllWindows()), ALT | Key_X);

      //---------Actions----------------------------
      QAction* backward = new QAction("backward",
         QIconSet(*backIcon), "&Backward",
        0, this, "backward");
      connect(backward, SIGNAL(activated()), browser, SLOT(backward()));

      QAction* forward = new QAction("forward",
         QIconSet(*forwardIcon), "&Forward",
        0, this, "forward");
      connect(forward, SIGNAL(activated()), browser, SLOT(forward()));

      QPopupMenu* go = new QPopupMenu(this);
      backward->addTo(go);
      forward->addTo(go);
      go->insertItem(*homeIcon, tr("&Home"), browser, SLOT(home()));

      bookm = new QPopupMenu(this);
      bookm->insertItem(tr("Add Bookmark"), this, SLOT(addBookmark()));
      bookm->insertSeparator();

      QStringList::Iterator it2 = bookmarks.begin();
      for ( ; it2 != bookmarks.end(); ++it2 ) {
            mBookmarks[ bookm->insertItem( *it2 ) ] = *it2;
            bookmarkList->insertItem(*it2);
            }

      connect(bookm, SIGNAL(activated(int)), SLOT(bookmChosen(int)));

      menuBar()->insertItem(tr("&File"), file);
      menuBar()->insertItem(tr("&Go"), go);
      menuBar()->insertItem(tr( "Bookmarks"), bookm);
      menuBar()->insertSeparator();

      connect(browser, SIGNAL(backwardAvailable(bool)),
         backward, SLOT(setEnabled(bool)));
      connect(browser, SIGNAL(forwardAvailable(bool)),
         forward, SLOT(setEnabled(bool)));

      QToolBar* toolbar = new QToolBar(this);
      addToolBar(toolbar, "Toolbar");
      QToolButton* button;

      backward->addTo(toolbar);
      forward->addTo(toolbar);

      button = new QToolButton(*homeIcon, tr("Home"), "", browser, SLOT(home()), toolbar);

      toolbar->addSeparator();
      button = new QToolButton(toolbar);
      button->setToggleButton(true);
      button->setPixmap(*tocIcon);
      button->setOn(true);
      connect(button, SIGNAL(toggled(bool)), SLOT(toggleToc(bool)));
      toolbar->addSeparator();

      pathCombo = new QComboBox(true, toolbar );
      connect( pathCombo, SIGNAL( activated( const QString & ) ),
         this, SLOT( pathSelected( const QString & ) ) );
      toolbar->setStretchableWidget( pathCombo );
      setRightJustification(true);
      setDockEnabled( Left, false);
      setDockEnabled( Right, false);

      pathCombo->insertItem( home_ );
      pathCombo->installEventFilter( this );
      QObjectList *l = queryList( "QLineEdit" );
      if ( l && l->first() )
            ( (QLineEdit*)l->first() )->installEventFilter( this );

      browser->setFocus();
      contentsSelected(contentsList->firstChild());
//      if (!home_.isEmpty())
//            browser->setSource(home_);
      }

//---------------------------------------------------------
//   bookmarkSelected
//---------------------------------------------------------

void HelpWindow::bookmarkSelected(QListBoxItem* item)
      {
      browser->setSource(item->text());
      }

//---------------------------------------------------------
//   contentsSelected
//---------------------------------------------------------

void HelpWindow::contentsSelected(QListViewItem* item)
      {
      if (item) {
//            printf("<%s> - <%s>\n", item->text(0).latin1(), item->text(1).latin1());
            browser->setSource(item->text(1));
            }
      }

//---------------------------------------------------------
//   HelpWindow
//---------------------------------------------------------

HelpWindow::~HelpWindow()
      {
      bookmarks.clear();
      QMap<int, QString>::Iterator it2 = mBookmarks.begin();
      for ( ; it2 != mBookmarks.end(); ++it2 )
            bookmarks.append( *it2 );

      QFile f2( QDir::currentDirPath() + "/.bookmarks" );
      f2.open( IO_WriteOnly );
      QDataStream s2( &f2 );
      s2 << bookmarks;
      f2.close();
      }

//---------------------------------------------------------
//   textChanged
//---------------------------------------------------------

void HelpWindow::textChanged()
      {
      if (browser->documentTitle().isNull())
            setCaption(browser->context());
      else
            setCaption(browser->documentTitle());
      selectedURL = caption();
      if (!selectedURL.isEmpty() && pathCombo) {
            path = QDir(QFileInfo(selectedURL).dirPath(true), "*.html *.htm");
            fileList = path.entryList();
            bool exists = false;
            int i;
            for (i = 0; i < pathCombo->count(); ++i) {
                  if (pathCombo->text(i) == selectedURL) {
                        exists = true;
                        break;
                        }
                  }
            if (!exists) {
                  pathCombo->insertItem(selectedURL, 0);
                  pathCombo->setCurrentItem(0);
                  }
            else
                  pathCombo->setCurrentItem(i);
            selectedURL = QString::null;
            }
      }

//---------------------------------------------------------
//   openFile
//---------------------------------------------------------

void HelpWindow::openFile()
      {
      QString fn = QFileDialog::getOpenFileName( QString::null, QString::null, this );
      if ( !fn.isEmpty() )
            browser->setSource(fn);
      }

//---------------------------------------------------------
//   newWindow
//---------------------------------------------------------

void HelpWindow::newWindow()
      {
      (new HelpWindow(browser->source(), "qbrowser"))->show();
      }

//---------------------------------------------------------
//   print
//---------------------------------------------------------

void HelpWindow::print()
      {
      QPrinter printer;
      printer.setFullPage(true);
      if ( printer.setup() ) {
            QPainter p( &printer );
            QPaintDeviceMetrics metrics(p.device());
            int dpix = metrics.logicalDpiX();
            int dpiy = metrics.logicalDpiY();
            const int margin = 72; // pt
            QRect body(margin*dpix/72, margin*dpiy/72,
		   metrics.width()-margin*dpix/72*2,
		   metrics.height()-margin*dpiy/72*2 );
            double scale = 0.75;
            p.scale(scale, scale );
            body = QRect( int(body.x()/scale), int(body.y()/scale),
		      int(body.width()/scale), int(body.height()/scale) );
            QFont font("times");
            QSimpleRichText richText( browser->text(), font, browser->context(), browser->styleSheet(),
               browser->mimeSourceFactory(), body.height() );
            richText.setWidth( &p, body.width() );
            QRect view( body );
            int page = 1;
            do {
                  richText.draw( &p, body.left(), body.top(), view, colorGroup() );
                  view.moveBy( 0, body.height() );
                  p.translate( 0 , -body.height() );
                  p.setFont( font );
                  p.drawText( view.right() - p.fontMetrics().width( QString::number(page) ),
                     view.bottom() + p.fontMetrics().ascent() + 5, QString::number(page) );
                  if ( view.top()  >= richText.height() )
                        break;
                  printer.newPage();
                  page++;
                  } while (true);
            }
      }

//---------------------------------------------------------
//   pathSelected
//---------------------------------------------------------

void HelpWindow::pathSelected(const QString &_path)
      {
      browser->setSource( _path );
      path = QDir(QFileInfo(_path).dirPath(true), "*.html *.htm");
      fileList = path.entryList();
      QMap<int, QString>::Iterator it = mHistory.begin();
      bool exists = false;
      for ( ; it != mHistory.end(); ++it) {
            if ( *it == _path ) {
                  exists = true;
                  break;
                  }
            }
      }

//---------------------------------------------------------
//   eventFilter
//---------------------------------------------------------

bool HelpWindow::eventFilter( QObject * o, QEvent * e )
      {
      if ( QMainWindow::eventFilter( o, e ) )
            return true;

      QObjectList *l = queryList( "QLineEdit" );
      if ( !l || !l->first() )
            return false;

      QLineEdit *lined = (QLineEdit*)l->first();

      if (( o == pathCombo || o == lined) &&
         e->type() == QEvent::KeyPress) {

//TODO            if ( isprint(((QKeyEvent *)e)) ) {
            if (1) {
                  if ( lined->hasMarkedText() )
                        lined->del();
                  QString nt( lined->text() );
                  nt.remove( 0, nt.findRev( '/' ) + 1 );
                  nt.truncate( lined->cursorPosition() );
                  nt += (char)(((QKeyEvent *)e));

                  QStringList::Iterator it = fileList.begin();
                  while ( it != fileList.end() && (*it).left( nt.length() ) != nt )
                        ++it;

                  if (!(*it).isEmpty()) {
                        nt = *it;
                        int cp = lined->cursorPosition() + 1;
                        int l = path.canonicalPath().length() + 1;
                        lined->validateAndSet( path.canonicalPath() + "/" + nt, cp, cp, l + nt.length() );
                        return true;
                        }
                  }
            }
      return false;
      }

//---------------------------------------------------------
//   readBookmark
//---------------------------------------------------------

void HelpWindow::readBookmarks()
      {
      if (QFile::exists( QDir::currentDirPath() + "/.bookmarks")) {
            QFile f( QDir::currentDirPath() + "/.bookmarks" );
            f.open( IO_ReadOnly );
            QDataStream s( &f );
            s >> bookmarks;
            f.close();
            }
      }

//---------------------------------------------------------
//   bookmChosen
//---------------------------------------------------------

void HelpWindow::bookmChosen(int i)
      {
      if (mBookmarks.contains(i))
            browser->setSource(mBookmarks[ i ]);
      }

//---------------------------------------------------------
//   addBookmark
//---------------------------------------------------------

void HelpWindow::addBookmark()
      {
      mBookmarks[bookm->insertItem(caption())] = caption();
      }

//---------------------------------------------------------
//   toggleToc
//---------------------------------------------------------

void HelpWindow::toggleToc(bool flag)
      {
      if (flag)
            tab->show();
      else
            tab->hide();
      }

