//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: audiodev.cpp,v 1.1 2002/01/30 14:10:08 muse Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "audiodev.h"
#include "seq.h"
#include "audioport.h"

AudioDeviceList audioDevices;

//---------------------------------------------------------
//   init
//---------------------------------------------------------

void AudioDevice::init()
      {
      _rwFlags    = 0;
      volL        = 0;
      volR        = 0;
      maxVolL     = 0;
      maxVolR     = 0;
      overflowL   = 0;
      overflowR   = 0;
      }

//---------------------------------------------------------
//   AudioDevice
//---------------------------------------------------------

AudioDevice::AudioDevice()
      {
      init();
      }

AudioDevice::AudioDevice(const QString& name)
   : Device(name, Device::WaveDevice)
      {
      init();
      }

int AudioDevice::rwFlags() const
      {
      return _rwFlags;
      }
AudioDevice::~AudioDevice()
      {
      }

//---------------------------------------------------------
//   find
//---------------------------------------------------------

AudioDevice* AudioDeviceList::find(const QString& s)
      {
      for (iAudioDevice i = begin(); i != end(); ++i)
            if ((*i)->name() == s)
                  return *i;
      return 0;
      }

