//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: alsamidi.cpp,v 1.3 2002/02/11 10:10:57 muse Exp $
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "globals.h"
#include "event.h"
#include "midithread.h"
#include "alsamidi.h"
#include "midirawdev.h"

snd_seq_t* alsaSeq;
int alsaSeqFd = -1;
snd_seq_addr_t musePort;

//---------------------------------------------------------
//   processInput
//---------------------------------------------------------

void alsaProcessMidiInput()
      {
      snd_seq_event_t* ev;
      for (;;) {
            int rv = snd_seq_event_input(alsaSeq, &ev);
            if (rv < 0)
                  break;
            switch(ev->type) {
                  case SND_SEQ_EVENT_PORT_SUBSCRIBED:
                  case SND_SEQ_EVENT_PORT_UNSUBSCRIBED:
                        return;
                  case SND_SEQ_EVENT_PORT_START:
                  case SND_SEQ_EVENT_PORT_EXIT:
//printf("alsaScanMidiPorts: event %d\n", ev->type);
                        alsaScanMidiPorts();
                        midiThread->midiPortsChanged();  // signal gui
                        snd_seq_free_event(ev);
                        return;
                  }

            int curPort = -1;
            //
            // find real source device
            //
            for (iMidiDevice i = midiDevices.begin(); i != midiDevices.end(); ++i) {
                  MidiAlsaDevice* d = dynamic_cast<MidiAlsaDevice*>(*i);
                  if (d  && d->adr.client == ev->source.client
                     && d->adr.port == ev->source.port) {
                        curPort = d->port();
                        }
                  }
// printf("port <%s> %d %d %d\n", name().latin1(), rwFlag, rwFlags(), port());
// printf("type %d\n", ev->type);

            if (curPort == -1) {
                  if (debugMsg) {
                        fprintf(stderr, "no port %d:%d found for received alsa event\n",
                           ev->source.client, ev->source.port);
                        }
                  snd_seq_free_event(ev);
                  return;
                  }
            switch(ev->type) {
                  case SND_SEQ_EVENT_NOTEON:
                  case SND_SEQ_EVENT_KEYPRESS:
                        {
                        MidiEvent* event = new MidiEvent(
                           curPort, ev->data.note.channel,
                           0,
                           MidiEvent::Note,
                           ev->data.note.note,
                           ev->data.note.velocity,
                           0, 0);
                        midiThread->eventReceived(event);
                        }
                        break;
                  case SND_SEQ_EVENT_NOTEOFF:
                        {
                        MidiEvent* event = new MidiEvent(
                           curPort,
                           ev->data.note.channel,
                           0,
                           MidiEvent::NoteOff,
                           ev->data.note.note,
                           ev->data.note.velocity,
                           0, 0);
                        midiThread->eventReceived(event);
                        }
                        break;
                  case SND_SEQ_EVENT_CHANPRESS:
                        {
                        MidiEvent* event = new MidiEvent(
                           curPort,
                           ev->data.control.channel,
                           0,
                           MidiEvent::CAfter,
                           ev->data.control.value,
                           0, 0, 0);
                        midiThread->eventReceived(event);
                        }
                        break;
                  case SND_SEQ_EVENT_PGMCHANGE:
                        {
                        MidiEvent* event = new MidiEvent(
                           curPort,
                           ev->data.control.channel,
                           0,
                           MidiEvent::Program,
                           ev->data.control.value,
                           0, 0, 0);
                        midiThread->eventReceived(event);
                        }
                        break;
                  case SND_SEQ_EVENT_PITCHBEND:
                        {
                        MidiEvent* event = new MidiEvent(
                           curPort,
                           ev->data.control.channel,
                           0,
                           MidiEvent::Pitch,
                           ev->data.control.value,
                           0, 0, 0);
                        midiThread->eventReceived(event);
                        }
                        break;

                  case SND_SEQ_EVENT_CONTROLLER:
                        {
                        MidiEvent* event = new MidiEvent(
                           curPort,
                           ev->data.control.channel,
                           0,
                           MidiEvent::Ctrl7,
                           ev->data.control.param,
                           ev->data.control.value,
                           0, 0);
                        midiThread->eventReceived(event);
                        }
                        break;

                  case SND_SEQ_EVENT_CLOCK:
                        midiThread->realtimeSystemInput(curPort, 0xf8);
                        break;

                  case SND_SEQ_EVENT_START:
                        midiThread->realtimeSystemInput(curPort, 0xfa);
                        break;
                  case SND_SEQ_EVENT_CONTINUE:
                        midiThread->realtimeSystemInput(curPort, 0xfb);
                        break;
                  case SND_SEQ_EVENT_STOP:
                        midiThread->realtimeSystemInput(curPort, 0xfc);
                        break;
                  case SND_SEQ_EVENT_TICK:
                        midiThread->realtimeSystemInput(curPort, 0xf9);
                        break;
                  case SND_SEQ_EVENT_SYSEX:
                        {
                        MidiEvent* event = new MidiEvent(curPort, 0,
                           0, MidiEvent::Sysex, ev->data.ext.len-2,
                           (unsigned char*)(ev->data.ext.ptr)+1);
                        midiThread->eventReceived(event);
                        }
                        break;
                  case SND_SEQ_EVENT_PORT_SUBSCRIBED:
                  case SND_SEQ_EVENT_PORT_UNSUBSCRIBED:  // write port is released
                        break;
                  case SND_SEQ_EVENT_SONGPOS:
                        midiThread->setSongPosition(curPort, ev->data.control.value);
                        break;
                  case SND_SEQ_EVENT_SENSING:
                        break;
                  case SND_SEQ_EVENT_CLIENT_START:
                  case SND_SEQ_EVENT_CLIENT_EXIT:
                  case SND_SEQ_EVENT_CLIENT_CHANGE:
                  case SND_SEQ_EVENT_PORT_CHANGE:
                  case SND_SEQ_EVENT_SONGSEL:
                  case SND_SEQ_EVENT_QFRAME:
                  case SND_SEQ_EVENT_TIMESIGN:
                  case SND_SEQ_EVENT_KEYSIGN:
                  case SND_SEQ_EVENT_SETPOS_TICK:
                  case SND_SEQ_EVENT_SETPOS_TIME:
                  case SND_SEQ_EVENT_TEMPO:
                  case SND_SEQ_EVENT_TUNE_REQUEST:
                  case SND_SEQ_EVENT_RESET:

                  case SND_SEQ_EVENT_NOTE:
                  case SND_SEQ_EVENT_CONTROL14:
                  case SND_SEQ_EVENT_NONREGPARAM:
                  case SND_SEQ_EVENT_REGPARAM:
                        break;
                  default:
                        printf("ALSA Midi input: type %d not handled\n", ev->type);
                        break;
                  }
            snd_seq_free_event(ev);
            if (rv == 0)
                  break;
            }
      }


