//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: tlist.h,v 1.2 2001/11/20 15:19:32 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __TLIST_H__
#define __TLIST_H__

#include "view.h"
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qheader.h>

#define TH  20                // normale Track-Hhe

class QPainter;
class ScrollScale;
class QLineEdit;
class Track;
class Xml;
// class QColor;
class Header;

enum TrackColumn {
      COL_RECORD = 0,
      COL_ACTIVITY,
      COL_MUTE,
      COL_CLASS,
      COL_NAME,
      COL_OPORT,
      COL_OCHANNEL,
      COL_TIMELOCK,
      COL_NONE = -1
      };

//----------------------------------------------------------
//   THeaderTip
//----------------------------------------------------------

class THeaderTip : public QToolTip {
   public:
      THeaderTip(QWidget * parent) : QToolTip(parent) {}
   protected:
      void maybeTip(const QPoint &);
      };

//---------------------------------------------------------
//   TList
//---------------------------------------------------------

class TList : public View {
      Header* header;
      ScrollScale* scroll;
      QLineEdit* editor;
      Track* editTrack;

      int startY;
      int curY;
      int sTrack;

      int activityMode;
      QColor activityColor, selectedTrackColor;

      enum { NORMAL, START_DRAG, DRAG } drag;

      virtual void draw(QPainter& p, const QRect&);
      virtual void viewMousePressEvent(QMouseEvent* event);
      virtual void viewMouseDoubleClickEvent(QMouseEvent*);
      virtual void viewMouseMoveEvent(QMouseEvent*);
      virtual void viewMouseReleaseEvent(QMouseEvent*);
      virtual void keyPressEvent(QKeyEvent* e);

      void portsPopupMenu(Track*, int, int);
      void classesPopupMenu(int, int, int);
      void oportPropertyPopupMenu(Track*, int x, int y);
      Q_OBJECT
      void moveSelection(int n);

   private slots:
      void returnPressed();
      void updateActivity();

   signals:
      void selectionChanged();

   public slots:
      void tracklistChanged();
      void setActivityMode(int);
      void setActivityColor(QColor);
      void setSelectedTrackColor(QColor);

   public:
      TList(Header*, QWidget* parent, int ymag);
      void setScroll(ScrollScale* s) { scroll = s; }
      Track* track() const { return editTrack; }
      void writeStatus(int level, Xml&, const char* name) const;
      void readStatus(Xml&, const char* name);
      int getActivityMode() const { return activityMode; }
      QColor getActivityColor() const { return activityColor; }
      QColor getSelectedTrackColor() const;
      };

#endif

