//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: app.h,v 1.8 2002/02/27 08:48:09 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __APP_H__
#define __APP_H__

#include "config.h"

#include "desk.h"
#include <qrect.h>
#include "cobject.h"
#include "tools.h"
#include <qfileinfo.h>

class Part;
class PartList;
class ToolBar;
class QPopupMenu;
class Transport;
class BigTime;
class Arranger;
class Instrument;
class QListView;
class QListViewItem;
class QPoint;
class QToolButton;
class Track;
class PrinterConfig;
class Mixer;
class MidiSyncConfig;
class MRConfig;
class MetronomeConfig;
class AudioConf;
class Xml;
class AudioMixerApp;
class ClipListEdit;
class AudioRecord;
class MidiFileConfig;
class MidiFilterConfig;
class MarkerView;
class HelpWindow;
class GlobalSettingsConfig;
class MidiControllerEditDialog;
class MidiInputTransformDialog;
class MidiTransformerDialog;
class SynthI;
class RhythmGen;

extern void configMidiController();

//---------------------------------------------------------
//   MusE
//---------------------------------------------------------

class MusE : public MainWindow
      {
      Q_OBJECT
      enum {CMD_CUT, CMD_COPY, CMD_PASTE, CMD_DELETE_TRACK, CMD_ADD_TRACK,
            CMD_SELECT_ALL, CMD_SELECT_NONE, CMD_SELECT_INVERT,
            CMD_SELECT_ILOOP, CMD_SELECT_OLOOP, CMD_SELECT_PARTS,
            CMD_FOLLOW_NO, CMD_FOLLOW_JUMP, CMD_FOLLOW_CONTINUOUS };

      QString appName;

      QString configName;
      QString _currentTheme;
      QString configTheme;
      QColor configSelectedTrackColor;
      QColor configActivityColor;
      int configActivityMode;

      QFileInfo project;

      ToolBar *tools;
      Transport* transport;
      BigTime* bigtime;
      QPopupMenu *menu_file, *menu_display, *menu_config, *menu_help;
      QPopupMenu *menuEdit;
      int tr_id, bt_id;
      QPopupMenu* follow;
      int fid0, fid1, fid2;
      QPopupMenu* midiInputPlugins;
      int mpid0, mpid1, mpid2, mpid3, mpid4;
      Arranger* arranger;

      QWidget* midiPortConfig;
      QWidget* softSynthesizerConfig;
      MidiSyncConfig* midiSyncConfig;
      MRConfig* midiRemoteConfig;
      RhythmGen* midiRhythmGenerator;
      MetronomeConfig* metronomeConfig;
      AudioConf* audioConfig;
      MidiFileConfig* midiFileConfig;
      GlobalSettingsConfig* globalSettingsConfig;
      MidiFilterConfig* midiFilterConfig;
      MidiInputTransformDialog* midiInputTransform;

      PrinterConfig* printerConfig;
      QRect configGeometryTransport;
      QRect configGeometryBigTime;
      bool configTransportVisible;
      bool configBigTimeVisible;
      QColor configTransportHandleColor;
      QColor configBigTimeForegroundColor;
      QColor configBigTimeBackgroundColor;

      ToplevelList toplevels;
      Mixer* midiMixer;
      ClipListEdit* clipListEdit;
      bool newSongFlag;
      MarkerView* markerView;
      HelpWindow* helpViewer;
      MidiTransformerDialog* midiTransformerDialog;
      QPopupMenu* openRecent;

      bool readMidi(FILE*);
      void read(Xml& xml);
      void write(Xml& xml) const;
      void genTransport();
      void genBigTime();
      bool clearSong();
      void initNewSong(const char* filename);
      void load();
      bool save(const QString&, bool);
      void setFollow();
      void readConfigTransport(Xml& xml);
      void readConfigBigTime(Xml& xml);
      void readConfigParts(Xml& xml);
      void readConfigPrinter(Xml& xml);
      void readMidiport(Xml& xml);
      void readMidichannel(Xml& xml, int port);
      void readCtrl(Xml& xml, int port, int channel);
      void readToplevels(Xml& xml);
      PartList* getMidiPartsToEdit();
      Part* readPart(Xml& xml);
      void writeSoftSynth(int, Xml&) const;
      void readSoftSynth(Xml&);

   protected:

   private slots:
      void newSong();
      void loadProject();
      bool save();
      bool saveAs();
      void configPrinter();
      void configGlobalSettings();
      void quitDoc();
      void about();
      void aboutQt();
      void helpBrowser();
      void importMidi();
      void importWave();
      bool importWave(const QString&);
      void exportMidi();

      void toggleTransport();
      void toggleBigTime();

      void configMidiPorts();
      void configSoftSynthesizer();
      void configAudioPorts();
      void configMidiSync();
      void configMidiFile();
      void configMetronome();
      void configAppearance();
      void startEditor(PartList*, int);
      void startScoreEditor();
      void startScoreEditor(PartList*);
      void startMasterEditor();
      void startLMasterEditor();
      void startListEditor();
      void startListEditor(PartList*);
      void startDrumEditor();
      void startDrumEditor(PartList*);
      void startEditor(Track*);
      void startPianoroll();
      void startPianoroll(PartList* pl);
      void startWaveEditor();
      void startWaveEditor(PartList*);
      void startMidiTransformer();
      bool readConfiguration();
      void readConfiguration(Xml&);
      void writeConfiguration() const;
      void writeConfiguration(int level, Xml&) const;
      void startMidiMixer();
      void startDefineController();
      void startClipList();
      void startMarkerView();

      void openRecentMenu();
      void selectProject(int id);
      void checkRecord(bool);
      void cmd(int);
      void clipboardChanged();
      void selectionChanged();
      void setMixdownFile();
      void transpose();
      void modifyGateTime();
      void modifyVelocity();
      void crescendo();
      void thinOut();
      void eraseEvent();
      void noteShift();
      void moveClock();
      void copyMeasure();
      void eraseMeasure();
      void deleteMeasure();
      void createMeasure();
      void mixTrack();
      void startMidiInputPlugin(int);
      void hideMitPluginTranspose();
      void hideMidiInputTransform();
      void hideMidiFilterConfig();
      void hideMidiRemoteConfig();
      void hideMidiRhythmGenerator();

   public slots:
      void closeEvent(QCloseEvent*e);
      void ctrlChanged();
      void loadProjectFile(const QString&);
      TopWin* startAudioMixer();
      void toplevelDeleted(int tl);
      void loadTheme(QString);
      void setTransportHandleColor(QColor);
      void setBigTimeForegroundColor(QColor);
      void setBigTimeBackgroundColor(QColor);
      void setBigTimeChecked(bool);

   public:
      MusE(int argc, char** argv);
      ~MusE();
      QRect configGeometryMain;
      bool importMidi(const QString);
      void kbAccel(int);
      QString currentTheme() const { return _currentTheme; }
      QColor getTransportHandleColor();
      QColor getBigTimeForegroundColor();
      QColor getBigTimeBackgroundColor();
      void configChanged();
      };

#endif

